@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Contains all the contact details of the customer.
 * @property companyName The name of the company.
 * @property contactPerson The contact person name.
 * @property emailList The email list.
 * @property phone The phone number.
 */
public data class ContactDetailsResponse(
    public val companyName: String,
    public val contactPerson: String,
    public val emailList: List<String>,
    public val phone: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.ContactDetailsResponse):
            ContactDetailsResponse = ContactDetailsResponse(
            companyName = javaType.companyName(),
            contactPerson = javaType.contactPerson(),
            emailList = javaType.emailList().map({ args0 -> args0 }),
            phone = javaType.phone(),
        )
    }
}
