@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The bandwidth schedule details.
 * @property days The days of the week when this schedule is applicable.
 * @property id The path ID that uniquely identifies the object.
 * @property name The object name.
 * @property rateInMbps The bandwidth rate in Mbps.
 * @property start The start time of the schedule in UTC.
 * @property stop The stop time of the schedule in UTC.
 * @property systemData Metadata pertaining to creation and last modification of BandwidthSchedule
 * @property type The hierarchical type of the object.
 */
public data class GetBandwidthScheduleResult(
    public val days: List<String>,
    public val id: String,
    public val name: String,
    public val rateInMbps: Int,
    public val start: String,
    public val stop: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetBandwidthScheduleResult):
            GetBandwidthScheduleResult = GetBandwidthScheduleResult(
            days = javaType.days().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            rateInMbps = javaType.rateInMbps(),
            start = javaType.start(),
            stop = javaType.stop(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
