@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The extended Info of the Data Box Edge/Gateway device.
 * @property channelIntegrityKeyName The name of Channel Integrity Key stored in the Client Key Vault
 * @property channelIntegrityKeyVersion The version of Channel Integrity Key stored in the Client Key Vault
 * @property clientSecretStoreId The Key Vault ARM Id for client secrets
 * @property clientSecretStoreUrl The url to access the Client Key Vault
 * @property cloudWitnessContainerName The Container for cloud witness in the storage account.
 * @property cloudWitnessStorageAccountName The Cloud Witness Storage account name.
 * @property cloudWitnessStorageEndpoint The Azure service endpoint of the cloud witness storage account.
 * @property clusterWitnessType Cluster Witness Type
 * @property deviceSecrets Device secrets, will be returned only with ODataFilter $expand=deviceSecrets
 * @property encryptionKey The public part of the encryption certificate. Client uses this to encrypt any secret.
 * @property encryptionKeyThumbprint The digital signature of encrypted certificate.
 * @property fileShareWitnessLocation The witness location of file share.
 * @property fileShareWitnessUsername The username of file share.
 * @property id The path ID that uniquely identifies the object.
 * @property keyVaultSyncStatus Key vault sync status
 * @property name The object name.
 * @property resourceKey The Resource ID of the Resource.
 * @property systemData Metadata pertaining to creation and last modification of DataBoxEdgeDevice
 * @property type The hierarchical type of the object.
 */
public data class GetDeviceExtendedInformationResult(
    public val channelIntegrityKeyName: String? = null,
    public val channelIntegrityKeyVersion: String? = null,
    public val clientSecretStoreId: String? = null,
    public val clientSecretStoreUrl: String? = null,
    public val cloudWitnessContainerName: String,
    public val cloudWitnessStorageAccountName: String,
    public val cloudWitnessStorageEndpoint: String,
    public val clusterWitnessType: String,
    public val deviceSecrets: Map<String, SecretResponse>,
    public val encryptionKey: String? = null,
    public val encryptionKeyThumbprint: String? = null,
    public val fileShareWitnessLocation: String,
    public val fileShareWitnessUsername: String,
    public val id: String,
    public val keyVaultSyncStatus: String? = null,
    public val name: String,
    public val resourceKey: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetDeviceExtendedInformationResult):
            GetDeviceExtendedInformationResult = GetDeviceExtendedInformationResult(
            channelIntegrityKeyName = javaType.channelIntegrityKeyName().map({ args0 -> args0 }).orElse(null),
            channelIntegrityKeyVersion = javaType.channelIntegrityKeyVersion().map({ args0 ->
                args0
            }).orElse(null),
            clientSecretStoreId = javaType.clientSecretStoreId().map({ args0 -> args0 }).orElse(null),
            clientSecretStoreUrl = javaType.clientSecretStoreUrl().map({ args0 -> args0 }).orElse(null),
            cloudWitnessContainerName = javaType.cloudWitnessContainerName(),
            cloudWitnessStorageAccountName = javaType.cloudWitnessStorageAccountName(),
            cloudWitnessStorageEndpoint = javaType.cloudWitnessStorageEndpoint(),
            clusterWitnessType = javaType.clusterWitnessType(),
            deviceSecrets = javaType.deviceSecrets().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.databoxedge.kotlin.outputs.SecretResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            encryptionKey = javaType.encryptionKey().map({ args0 -> args0 }).orElse(null),
            encryptionKeyThumbprint = javaType.encryptionKeyThumbprint().map({ args0 -> args0 }).orElse(null),
            fileShareWitnessLocation = javaType.fileShareWitnessLocation(),
            fileShareWitnessUsername = javaType.fileShareWitnessUsername(),
            id = javaType.id(),
            keyVaultSyncStatus = javaType.keyVaultSyncStatus().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            resourceKey = javaType.resourceKey(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
