@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The Data Box Edge/Gateway device.
 * @property configuredRoleTypes Type of compute roles configured.
 * @property culture The Data Box Edge/Gateway device culture.
 * @property dataBoxEdgeDeviceStatus The status of the Data Box Edge/Gateway device.
 * @property dataResidency The details of data-residency related properties for this resource
 * @property description The Description of the Data Box Edge/Gateway device.
 * @property deviceHcsVersion The device software version number of the device (eg: 1.2.18105.6).
 * @property deviceLocalCapacity The Data Box Edge/Gateway device local capacity in MB.
 * @property deviceModel The Data Box Edge/Gateway device model.
 * @property deviceSoftwareVersion The Data Box Edge/Gateway device software version.
 * @property deviceType The type of the Data Box Edge/Gateway device.
 * @property edgeProfile The details of Edge Profile for this resource
 * @property etag The etag for the devices.
 * @property friendlyName The Data Box Edge/Gateway device name.
 * @property id The path ID that uniquely identifies the object.
 * @property identity Msi identity of the resource
 * @property kind The kind of the device.
 * @property location The location of the device. This is a supported and registered Azure geographical region (for example, West US, East US, or Southeast Asia). The geographical region of a device cannot be changed once it is created, but if an identical geographical region is specified on update, the request will succeed.
 * @property modelDescription The description of the Data Box Edge/Gateway device model.
 * @property name The object name.
 * @property nodeCount The number of nodes in the cluster.
 * @property resourceMoveDetails The details of the move operation on this resource.
 * @property serialNumber The Serial Number of Data Box Edge/Gateway device.
 * @property sku The SKU type.
 * @property systemData DataBoxEdge Resource
 * @property tags The list of tags that describe the device. These tags can be used to view and group this device (across resource groups).
 * @property timeZone The Data Box Edge/Gateway device timezone.
 * @property type The hierarchical type of the object.
 */
public data class GetDeviceResult(
    public val configuredRoleTypes: List<String>,
    public val culture: String,
    public val dataBoxEdgeDeviceStatus: String,
    public val dataResidency: DataResidencyResponse? = null,
    public val description: String,
    public val deviceHcsVersion: String,
    public val deviceLocalCapacity: Double,
    public val deviceModel: String,
    public val deviceSoftwareVersion: String,
    public val deviceType: String,
    public val edgeProfile: EdgeProfileResponse,
    public val etag: String? = null,
    public val friendlyName: String,
    public val id: String,
    public val identity: ResourceIdentityResponse? = null,
    public val kind: String,
    public val location: String,
    public val modelDescription: String,
    public val name: String,
    public val nodeCount: Int,
    public val resourceMoveDetails: ResourceMoveDetailsResponse,
    public val serialNumber: String,
    public val sku: SkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val timeZone: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetDeviceResult):
            GetDeviceResult = GetDeviceResult(
            configuredRoleTypes = javaType.configuredRoleTypes().map({ args0 -> args0 }),
            culture = javaType.culture(),
            dataBoxEdgeDeviceStatus = javaType.dataBoxEdgeDeviceStatus(),
            dataResidency = javaType.dataResidency().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.DataResidencyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description(),
            deviceHcsVersion = javaType.deviceHcsVersion(),
            deviceLocalCapacity = javaType.deviceLocalCapacity(),
            deviceModel = javaType.deviceModel(),
            deviceSoftwareVersion = javaType.deviceSoftwareVersion(),
            deviceType = javaType.deviceType(),
            edgeProfile = javaType.edgeProfile().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.EdgeProfileResponse.Companion.toKotlin(args0)
            }),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            friendlyName = javaType.friendlyName(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kind = javaType.kind(),
            location = javaType.location(),
            modelDescription = javaType.modelDescription(),
            name = javaType.name(),
            nodeCount = javaType.nodeCount(),
            resourceMoveDetails = javaType.resourceMoveDetails().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.ResourceMoveDetailsResponse.Companion.toKotlin(args0)
            }),
            serialNumber = javaType.serialNumber(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeZone = javaType.timeZone(),
            type = javaType.type(),
        )
    }
}
