@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.Suppress

/**
 * Kubernetes role resources
 * @property compute Kubernetes role compute resource
 * @property network Kubernetes role network resource
 * @property storage Kubernetes role storage resource
 */
public data class KubernetesRoleResourcesResponse(
    public val compute: KubernetesRoleComputeResponse,
    public val network: KubernetesRoleNetworkResponse,
    public val storage: KubernetesRoleStorageResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.KubernetesRoleResourcesResponse):
            KubernetesRoleResourcesResponse = KubernetesRoleResourcesResponse(
            compute = javaType.compute().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.KubernetesRoleComputeResponse.Companion.toKotlin(args0)
            }),
            network = javaType.network().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.KubernetesRoleNetworkResponse.Companion.toKotlin(args0)
            }),
            storage = javaType.storage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.KubernetesRoleStorageResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
