@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Msi identity details of the resource
 * @property principalId Service Principal Id backing the Msi
 * @property tenantId Home Tenant Id
 * @property type Identity type
 */
public data class ResourceIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.ResourceIdentityResponse):
            ResourceIdentityResponse = ResourceIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
