@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.Suppress

/**
 * Symmetric key for authentication.
 * @property connectionString Connection string based on the symmetric key.
 */
public data class SymmetricKeyResponse(
    public val connectionString: AsymmetricEncryptedSecretResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.SymmetricKeyResponse):
            SymmetricKeyResponse = SymmetricKeyResponse(
            connectionString = javaType.connectionString().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.AsymmetricEncryptedSecretResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
