@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.EncryptionEntitiesDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Encryption entities for databricks workspace resource.
 * @property managedDisk Encryption properties for the databricks managed disks.
 * @property managedServices Encryption properties for the databricks managed services.
 */
public data class EncryptionEntitiesDefinitionArgs(
    public val managedDisk: Output<ManagedDiskEncryptionArgs>? = null,
    public val managedServices: Output<EncryptionV2Args>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.EncryptionEntitiesDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.databricks.inputs.EncryptionEntitiesDefinitionArgs =
        com.pulumi.azurenative.databricks.inputs.EncryptionEntitiesDefinitionArgs.builder()
            .managedDisk(managedDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managedServices(
                managedServices?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionEntitiesDefinitionArgs].
 */
@PulumiTagMarker
public class EncryptionEntitiesDefinitionArgsBuilder internal constructor() {
    private var managedDisk: Output<ManagedDiskEncryptionArgs>? = null

    private var managedServices: Output<EncryptionV2Args>? = null

    /**
     * @param value Encryption properties for the databricks managed disks.
     */
    @JvmName("swlusrjsxxbvduqq")
    public suspend fun managedDisk(`value`: Output<ManagedDiskEncryptionArgs>) {
        this.managedDisk = value
    }

    /**
     * @param value Encryption properties for the databricks managed services.
     */
    @JvmName("kjpryqkwekvnfyjp")
    public suspend fun managedServices(`value`: Output<EncryptionV2Args>) {
        this.managedServices = value
    }

    /**
     * @param value Encryption properties for the databricks managed disks.
     */
    @JvmName("yotfbmbuojapepgc")
    public suspend fun managedDisk(`value`: ManagedDiskEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedDisk = mapped
    }

    /**
     * @param argument Encryption properties for the databricks managed disks.
     */
    @JvmName("fehtlempoyjtbwcx")
    public suspend fun managedDisk(argument: suspend ManagedDiskEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedDiskEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedDisk = mapped
    }

    /**
     * @param value Encryption properties for the databricks managed services.
     */
    @JvmName("mttwheyphgjfhmqk")
    public suspend fun managedServices(`value`: EncryptionV2Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedServices = mapped
    }

    /**
     * @param argument Encryption properties for the databricks managed services.
     */
    @JvmName("wdefktoerqayngvm")
    public suspend fun managedServices(argument: suspend EncryptionV2ArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionV2ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedServices = mapped
    }

    internal fun build(): EncryptionEntitiesDefinitionArgs = EncryptionEntitiesDefinitionArgs(
        managedDisk = managedDisk,
        managedServices = managedServices,
    )
}
