@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.EncryptionV2Args.builder
import com.pulumi.azurenative.databricks.kotlin.enums.EncryptionKeySource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The object that contains details of encryption used on the workspace.
 * @property keySource The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Keyvault
 * @property keyVaultProperties Key Vault input properties for encryption.
 */
public data class EncryptionV2Args(
    public val keySource: Output<Either<String, EncryptionKeySource>>,
    public val keyVaultProperties: Output<EncryptionV2KeyVaultPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.EncryptionV2Args> {
    override fun toJava(): com.pulumi.azurenative.databricks.inputs.EncryptionV2Args =
        com.pulumi.azurenative.databricks.inputs.EncryptionV2Args.builder()
            .keySource(
                keySource.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionV2Args].
 */
@PulumiTagMarker
public class EncryptionV2ArgsBuilder internal constructor() {
    private var keySource: Output<Either<String, EncryptionKeySource>>? = null

    private var keyVaultProperties: Output<EncryptionV2KeyVaultPropertiesArgs>? = null

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Keyvault
     */
    @JvmName("udiwiefelvirtkwt")
    public suspend fun keySource(`value`: Output<Either<String, EncryptionKeySource>>) {
        this.keySource = value
    }

    /**
     * @param value Key Vault input properties for encryption.
     */
    @JvmName("pxprfbtmreipdfjb")
    public suspend fun keyVaultProperties(`value`: Output<EncryptionV2KeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Keyvault
     */
    @JvmName("wdvmvwbnjaihcqgi")
    public suspend fun keySource(`value`: Either<String, EncryptionKeySource>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Keyvault
     */
    @JvmName("dinrewfagrhkiyrc")
    public fun keySource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionKeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Keyvault
     */
    @JvmName("cvpqojdtjwyuiqgy")
    public fun keySource(`value`: EncryptionKeySource) {
        val toBeMapped = Either.ofRight<String, EncryptionKeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Key Vault input properties for encryption.
     */
    @JvmName("cjraeycatixcdtaq")
    public suspend fun keyVaultProperties(`value`: EncryptionV2KeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Key Vault input properties for encryption.
     */
    @JvmName("lqmymijdestduijm")
    public suspend
    fun keyVaultProperties(argument: suspend EncryptionV2KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionV2KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    internal fun build(): EncryptionV2Args = EncryptionV2Args(
        keySource = keySource ?: throw PulumiNullFieldException("keySource"),
        keyVaultProperties = keyVaultProperties,
    )
}
