@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.GetVNetPeeringPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property peeringName The name of the workspace vNet peering.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetVNetPeeringPlainArgs(
    public val peeringName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.GetVNetPeeringPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.databricks.inputs.GetVNetPeeringPlainArgs =
        com.pulumi.azurenative.databricks.inputs.GetVNetPeeringPlainArgs.builder()
            .peeringName(peeringName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVNetPeeringPlainArgs].
 */
@PulumiTagMarker
public class GetVNetPeeringPlainArgsBuilder internal constructor() {
    private var peeringName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the workspace vNet peering.
     */
    @JvmName("bwwcsrwrqppwxlqa")
    public suspend fun peeringName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peeringName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rmgmtmkyrppmmatp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("mwcjarygoguwetix")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetVNetPeeringPlainArgs = GetVNetPeeringPlainArgs(
        peeringName = peeringName ?: throw PulumiNullFieldException("peeringName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
