@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.ManagedDiskEncryptionKeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Key Vault input properties for encryption.
 * @property keyName The name of KeyVault key.
 * @property keyVaultUri The URI of KeyVault.
 * @property keyVersion The version of KeyVault key.
 */
public data class ManagedDiskEncryptionKeyVaultPropertiesArgs(
    public val keyName: Output<String>,
    public val keyVaultUri: Output<String>,
    public val keyVersion: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.ManagedDiskEncryptionKeyVaultPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.databricks.inputs.ManagedDiskEncryptionKeyVaultPropertiesArgs =
        com.pulumi.azurenative.databricks.inputs.ManagedDiskEncryptionKeyVaultPropertiesArgs.builder()
            .keyName(keyName.applyValue({ args0 -> args0 }))
            .keyVaultUri(keyVaultUri.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedDiskEncryptionKeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class ManagedDiskEncryptionKeyVaultPropertiesArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var keyVaultUri: Output<String>? = null

    private var keyVersion: Output<String>? = null

    /**
     * @param value The name of KeyVault key.
     */
    @JvmName("yullwwqyjaebtalk")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The URI of KeyVault.
     */
    @JvmName("wkowldradokeeemd")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value The version of KeyVault key.
     */
    @JvmName("kpubqishddsotfom")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value The name of KeyVault key.
     */
    @JvmName("isvwxedwulrfrgrv")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The URI of KeyVault.
     */
    @JvmName("apgphdbyflwjcjec")
    public suspend fun keyVaultUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    /**
     * @param value The version of KeyVault key.
     */
    @JvmName("nheemrnlynhgciwf")
    public suspend fun keyVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    internal fun build(): ManagedDiskEncryptionKeyVaultPropertiesArgs =
        ManagedDiskEncryptionKeyVaultPropertiesArgs(
            keyName = keyName ?: throw PulumiNullFieldException("keyName"),
            keyVaultUri = keyVaultUri ?: throw PulumiNullFieldException("keyVaultUri"),
            keyVersion = keyVersion ?: throw PulumiNullFieldException("keyVersion"),
        )
}
