@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.SkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU for the resource.
 * @property name The SKU name.
 * @property tier The SKU tier.
 */
public data class SkuArgs(
    public val name: Output<String>,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.databricks.inputs.SkuArgs =
        com.pulumi.azurenative.databricks.inputs.SkuArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value The SKU name.
     */
    @JvmName("urjumkxphlhqjeca")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The SKU tier.
     */
    @JvmName("xxhaqdsryxwdttxm")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value The SKU name.
     */
    @JvmName("gofquegvkxaodjvm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The SKU tier.
     */
    @JvmName("nxkhiqnsnnldgasl")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tier = tier,
    )
}
