@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The object that contains details of encryption used on the workspace.
 * @property keyName The name of KeyVault key.
 * @property keySource The encryption keySource (provider). Possible values (case-insensitive):  Default, Microsoft.Keyvault
 * @property keyVaultUri The Uri of KeyVault.
 * @property keyVersion The version of KeyVault key.
 */
public data class EncryptionResponse(
    public val keyName: String? = null,
    public val keySource: String? = null,
    public val keyVaultUri: String? = null,
    public val keyVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databricks.outputs.EncryptionResponse):
            EncryptionResponse = EncryptionResponse(
            keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
            keySource = javaType.keySource().map({ args0 -> args0 }).orElse(null),
            keyVaultUri = javaType.keyVaultUri().map({ args0 -> args0 }).orElse(null),
            keyVersion = javaType.keyVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
