@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Key Vault input properties for encryption.
 * @property keyName The name of KeyVault key.
 * @property keyVaultUri The Uri of KeyVault.
 * @property keyVersion The version of KeyVault key.
 */
public data class EncryptionV2ResponseKeyVaultProperties(
    public val keyName: String,
    public val keyVaultUri: String,
    public val keyVersion: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databricks.outputs.EncryptionV2ResponseKeyVaultProperties):
            EncryptionV2ResponseKeyVaultProperties = EncryptionV2ResponseKeyVaultProperties(
            keyName = javaType.keyName(),
            keyVaultUri = javaType.keyVaultUri(),
            keyVersion = javaType.keyVersion(),
        )
    }
}
