@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datacatalog.kotlin

import com.pulumi.azurenative.datacatalog.DatacatalogFunctions.getADCCatalogPlain
import com.pulumi.azurenative.datacatalog.kotlin.inputs.GetADCCatalogPlainArgs
import com.pulumi.azurenative.datacatalog.kotlin.inputs.GetADCCatalogPlainArgsBuilder
import com.pulumi.azurenative.datacatalog.kotlin.outputs.GetADCCatalogResult
import com.pulumi.azurenative.datacatalog.kotlin.outputs.GetADCCatalogResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object DatacatalogFunctions {
    /**
     * The Get Azure Data Catalog Service operation retrieves a json representation of the data catalog.
     * Azure REST API version: 2016-03-30.
     * @param argument null
     * @return Azure Data Catalog.
     */
    public suspend fun getADCCatalog(argument: GetADCCatalogPlainArgs): GetADCCatalogResult =
        toKotlin(getADCCatalogPlain(argument.toJava()).await())

    /**
     * @see [getADCCatalog].
     * @param catalogName The name of the data catalog in the specified subscription and resource group.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return Azure Data Catalog.
     */
    public suspend fun getADCCatalog(catalogName: String, resourceGroupName: String):
        GetADCCatalogResult {
        val argument = GetADCCatalogPlainArgs(
            catalogName = catalogName,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getADCCatalogPlain(argument.toJava()).await())
    }

    /**
     * @see [getADCCatalog].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datacatalog&#46;kotlin&#46;inputs&#46;GetADCCatalogPlainArgs].
     * @return Azure Data Catalog.
     */
    public suspend fun getADCCatalog(argument: suspend GetADCCatalogPlainArgsBuilder.() -> Unit):
        GetADCCatalogResult {
        val builder = GetADCCatalogPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getADCCatalogPlain(builtArgument.toJava()).await())
    }
}
