@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin

import com.pulumi.azurenative.datadog.kotlin.outputs.SubscriptionListResponse
import com.pulumi.azurenative.datadog.kotlin.outputs.SubscriptionListResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MonitoredSubscription].
 */
@PulumiTagMarker
public class MonitoredSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MonitoredSubscriptionArgs = MonitoredSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MonitoredSubscriptionArgsBuilder.() -> Unit) {
        val builder = MonitoredSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MonitoredSubscription {
        val builtJavaResource =
            com.pulumi.azurenative.datadog.MonitoredSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MonitoredSubscription(builtJavaResource)
    }
}

/**
 * The request to update subscriptions needed to be monitored by the Datadog monitor resource.
 * Azure REST API version: 2023-01-01.
 * ## Example Usage
 * ### Monitors_AddMonitoredSubscriptions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var monitoredSubscription = new AzureNative.Datadog.MonitoredSubscription("monitoredSubscription", new()
 *     {
 *         ConfigurationName = "default",
 *         MonitorName = "myMonitor",
 *         Properties = new AzureNative.Datadog.Inputs.SubscriptionListArgs
 *         {
 *             MonitoredSubscriptionList = new[]
 *             {
 *                 new AzureNative.Datadog.Inputs.MonitoredSubscriptionArgs
 *                 {
 *                     Status = "Active",
 *                     SubscriptionId = "/subscriptions/00000000-0000-0000-0000-000000000000",
 *                     TagRules = new AzureNative.Datadog.Inputs.MonitoringTagRulesPropertiesArgs
 *                     {
 *                         Automuting = true,
 *                         LogRules = new AzureNative.Datadog.Inputs.LogRulesArgs
 *                         {
 *                             FilteringTags = new[]
 *                             {
 *                                 new AzureNative.Datadog.Inputs.FilteringTagArgs
 *                                 {
 *                                     Action = "Include",
 *                                     Name = "Environment",
 *                                     Value = "Prod",
 *                                 },
 *                                 new AzureNative.Datadog.Inputs.FilteringTagArgs
 *                                 {
 *                                     Action = "Exclude",
 *                                     Name = "Environment",
 *                                     Value = "Dev",
 *                                 },
 *                             },
 *                             SendAadLogs = false,
 *                             SendResourceLogs = true,
 *                             SendSubscriptionLogs = true,
 *                         },
 *                         MetricRules = new AzureNative.Datadog.Inputs.MetricRulesArgs
 *                         {
 *                             FilteringTags = new[] {},
 *                         },
 *                     },
 *                 },
 *                 new AzureNative.Datadog.Inputs.MonitoredSubscriptionArgs
 *                 {
 *                     Status = "Failed",
 *                     SubscriptionId = "/subscriptions/00000000-0000-0000-0000-000000000001",
 *                     TagRules = new AzureNative.Datadog.Inputs.MonitoringTagRulesPropertiesArgs
 *                     {
 *                         Automuting = true,
 *                         LogRules = new AzureNative.Datadog.Inputs.LogRulesArgs
 *                         {
 *                             FilteringTags = new[]
 *                             {
 *                                 new AzureNative.Datadog.Inputs.FilteringTagArgs
 *                                 {
 *                                     Action = "Include",
 *                                     Name = "Environment",
 *                                     Value = "Prod",
 *                                 },
 *                                 new AzureNative.Datadog.Inputs.FilteringTagArgs
 *                                 {
 *                                     Action = "Exclude",
 *                                     Name = "Environment",
 *                                     Value = "Dev",
 *                                 },
 *                             },
 *                             SendAadLogs = false,
 *                             SendResourceLogs = true,
 *                             SendSubscriptionLogs = true,
 *                         },
 *                         MetricRules = new AzureNative.Datadog.Inputs.MetricRulesArgs
 *                         {
 *                             FilteringTags = new[] {},
 *                         },
 *                     },
 *                 },
 *             },
 *             Operation = "AddBegin",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datadog/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datadog.NewMonitoredSubscription(ctx, "monitoredSubscription", &datadog.MonitoredSubscriptionArgs{
 * ConfigurationName: pulumi.String("default"),
 * MonitorName: pulumi.String("myMonitor"),
 * Properties: datadog.SubscriptionListResponse{
 * MonitoredSubscriptionList: datadog.MonitoredSubscriptionTypeArray{
 * interface{}{
 * Status: pulumi.String("Active"),
 * SubscriptionId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000"),
 * TagRules: interface{}{
 * Automuting: pulumi.Bool(true),
 * LogRules: interface{}{
 * FilteringTags: datadog.FilteringTagArray{
 * &datadog.FilteringTagArgs{
 * Action: pulumi.String("Include"),
 * Name: pulumi.String("Environment"),
 * Value: pulumi.String("Prod"),
 * },
 * &datadog.FilteringTagArgs{
 * Action: pulumi.String("Exclude"),
 * Name: pulumi.String("Environment"),
 * Value: pulumi.String("Dev"),
 * },
 * },
 * SendAadLogs: pulumi.Bool(false),
 * SendResourceLogs: pulumi.Bool(true),
 * SendSubscriptionLogs: pulumi.Bool(true),
 * },
 * MetricRules: interface{}{
 * FilteringTags: datadog.FilteringTagArray{
 * },
 * },
 * },
 * },
 * interface{}{
 * Status: pulumi.String("Failed"),
 * SubscriptionId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000001"),
 * TagRules: interface{}{
 * Automuting: pulumi.Bool(true),
 * LogRules: interface{}{
 * FilteringTags: datadog.FilteringTagArray{
 * &datadog.FilteringTagArgs{
 * Action: pulumi.String("Include"),
 * Name: pulumi.String("Environment"),
 * Value: pulumi.String("Prod"),
 * },
 * &datadog.FilteringTagArgs{
 * Action: pulumi.String("Exclude"),
 * Name: pulumi.String("Environment"),
 * Value: pulumi.String("Dev"),
 * },
 * },
 * SendAadLogs: pulumi.Bool(false),
 * SendResourceLogs: pulumi.Bool(true),
 * SendSubscriptionLogs: pulumi.Bool(true),
 * },
 * MetricRules: interface{}{
 * FilteringTags: datadog.FilteringTagArray{
 * },
 * },
 * },
 * },
 * },
 * Operation: pulumi.String("AddBegin"),
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datadog.MonitoredSubscription;
 * import com.pulumi.azurenative.datadog.MonitoredSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var monitoredSubscription = new MonitoredSubscription("monitoredSubscription", MonitoredSubscriptionArgs.builder()
 *             .configurationName("default")
 *             .monitorName("myMonitor")
 *             .properties(Map.ofEntries(
 *                 Map.entry("monitoredSubscriptionList",
 *                     Map.ofEntries(
 *                         Map.entry("status", "Active"),
 *                         Map.entry("subscriptionId", "/subscriptions/00000000-0000-0000-0000-000000000000"),
 *                         Map.entry("tagRules", Map.ofEntries(
 *                             Map.entry("automuting", true),
 *                             Map.entry("logRules", Map.ofEntries(
 *                                 Map.entry("filteringTags",
 *                                     Map.ofEntries(
 *                                         Map.entry("action", "Include"),
 *                                         Map.entry("name", "Environment"),
 *                                         Map.entry("value", "Prod")
 *                                     ),
 *                                     Map.ofEntries(
 *                                         Map.entry("action", "Exclude"),
 *                                         Map.entry("name", "Environment"),
 *                                         Map.entry("value", "Dev")
 *                                     )),
 *                                 Map.entry("sendAadLogs", false),
 *                                 Map.entry("sendResourceLogs", true),
 *                                 Map.entry("sendSubscriptionLogs", true)
 *                             )),
 *                             Map.entry("metricRules", Map.of("filteringTags", ))
 *                         ))
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("status", "Failed"),
 *                         Map.entry("subscriptionId", "/subscriptions/00000000-0000-0000-0000-000000000001"),
 *                         Map.entry("tagRules", Map.ofEntries(
 *                             Map.entry("automuting", true),
 *                             Map.entry("logRules", Map.ofEntries(
 *                                 Map.entry("filteringTags",
 *                                     Map.ofEntries(
 *                                         Map.entry("action", "Include"),
 *                                         Map.entry("name", "Environment"),
 *                                         Map.entry("value", "Prod")
 *                                     ),
 *                                     Map.ofEntries(
 *                                         Map.entry("action", "Exclude"),
 *                                         Map.entry("name", "Environment"),
 *                                         Map.entry("value", "Dev")
 *                                     )),
 *                                 Map.entry("sendAadLogs", false),
 *                                 Map.entry("sendResourceLogs", true),
 *                                 Map.entry("sendSubscriptionLogs", true)
 *                             )),
 *                             Map.entry("metricRules", Map.of("filteringTags", ))
 *                         ))
 *                     )),
 *                 Map.entry("operation", "AddBegin")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datadog:MonitoredSubscription default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Datadog/monitors/{monitorName}/monitoredSubscriptions/{configurationName}
 * ```
 */
public class MonitoredSubscription internal constructor(
    override val javaResource: com.pulumi.azurenative.datadog.MonitoredSubscription,
) : KotlinCustomResource(javaResource, MonitoredSubscriptionMapper) {
    /**
     * Name of the monitored subscription resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The request to update subscriptions needed to be monitored by the Datadog monitor resource.
     */
    public val properties: Output<SubscriptionListResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the monitored subscription resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MonitoredSubscriptionMapper : ResourceMapper<MonitoredSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datadog.MonitoredSubscription::class == javaResource::class

    override fun map(javaResource: Resource): MonitoredSubscription =
        MonitoredSubscription(javaResource as com.pulumi.azurenative.datadog.MonitoredSubscription)
}

/**
 * @see [MonitoredSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MonitoredSubscription].
 */
public suspend fun monitoredSubscription(
    name: String,
    block: suspend MonitoredSubscriptionResourceBuilder.() -> Unit,
): MonitoredSubscription {
    val builder = MonitoredSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MonitoredSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun monitoredSubscription(name: String): MonitoredSubscription {
    val builder = MonitoredSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
