@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.inputs

import com.pulumi.azurenative.datadog.inputs.IdentityPropertiesArgs.builder
import com.pulumi.azurenative.datadog.kotlin.enums.ManagedIdentityTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type Identity type
 */
public data class IdentityPropertiesArgs(
    public val type: Output<Either<String, ManagedIdentityTypes>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datadog.inputs.IdentityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datadog.inputs.IdentityPropertiesArgs =
        com.pulumi.azurenative.datadog.inputs.IdentityPropertiesArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentityPropertiesArgs].
 */
@PulumiTagMarker
public class IdentityPropertiesArgsBuilder internal constructor() {
    private var type: Output<Either<String, ManagedIdentityTypes>>? = null

    /**
     * @param value Identity type
     */
    @JvmName("vxherbrglcogwnoq")
    public suspend fun type(`value`: Output<Either<String, ManagedIdentityTypes>>) {
        this.type = value
    }

    /**
     * @param value Identity type
     */
    @JvmName("xrvajofsrreospyn")
    public suspend fun type(`value`: Either<String, ManagedIdentityTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Identity type
     */
    @JvmName("gucvuinixfrrfsro")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedIdentityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Identity type
     */
    @JvmName("nledckpdoxreyoqv")
    public fun type(`value`: ManagedIdentityTypes) {
        val toBeMapped = Either.ofRight<String, ManagedIdentityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IdentityPropertiesArgs = IdentityPropertiesArgs(
        type = type,
    )
}
