@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The request to update subscriptions needed to be monitored by the Datadog monitor resource.
 * @property monitoredSubscriptionList List of subscriptions and the state of the monitoring.
 */
public data class SubscriptionListResponse(
    public val monitoredSubscriptionList: List<MonitoredSubscriptionResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datadog.outputs.SubscriptionListResponse):
            SubscriptionListResponse = SubscriptionListResponse(
            monitoredSubscriptionList = javaType.monitoredSubscriptionList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datadog.kotlin.outputs.MonitoredSubscriptionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
