@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.ChangeDataCaptureArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.inputs.ChangeDataCaptureFolderArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.ChangeDataCaptureFolderArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.MapperPolicyArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.MapperPolicyArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.MapperSourceConnectionsInfoArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.MapperSourceConnectionsInfoArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.MapperTargetConnectionsInfoArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.MapperTargetConnectionsInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Change data capture resource type.
 * Azure REST API version: 2018-06-01.
 * ## Example Usage
 * ### ChangeDataCapture_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var changeDataCapture = new AzureNative.DataFactory.ChangeDataCapture("changeDataCapture", new()
 *     {
 *         AllowVNetOverride = false,
 *         ChangeDataCaptureName = "exampleChangeDataCapture",
 *         Description = "Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database with automapped and non-automapped mappings.",
 *         FactoryName = "exampleFactoryName",
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewChangeDataCapture(ctx, "changeDataCapture", &datafactory.ChangeDataCaptureArgs{
 * 			AllowVNetOverride:     pulumi.Bool(false),
 * 			ChangeDataCaptureName: pulumi.String("exampleChangeDataCapture"),
 * 			Description:           pulumi.String("Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database with automapped and non-automapped mappings."),
 * 			FactoryName:           pulumi.String("exampleFactoryName"),
 * 			ResourceGroupName:     pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.ChangeDataCapture;
 * import com.pulumi.azurenative.datafactory.ChangeDataCaptureArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var changeDataCapture = new ChangeDataCapture("changeDataCapture", ChangeDataCaptureArgs.builder()
 *             .allowVNetOverride(false)
 *             .changeDataCaptureName("exampleChangeDataCapture")
 *             .description("Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database with automapped and non-automapped mappings.")
 *             .factoryName("exampleFactoryName")
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### ChangeDataCapture_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var changeDataCapture = new AzureNative.DataFactory.ChangeDataCapture("changeDataCapture", new()
 *     {
 *         AllowVNetOverride = false,
 *         ChangeDataCaptureName = "exampleChangeDataCapture",
 *         Description = "Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database. Updating table mappings.",
 *         FactoryName = "exampleFactoryName",
 *         ResourceGroupName = "exampleResourceGroup",
 *         Status = "Stopped",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewChangeDataCapture(ctx, "changeDataCapture", &datafactory.ChangeDataCaptureArgs{
 * 			AllowVNetOverride:     pulumi.Bool(false),
 * 			ChangeDataCaptureName: pulumi.String("exampleChangeDataCapture"),
 * 			Description:           pulumi.String("Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database. Updating table mappings."),
 * 			FactoryName:           pulumi.String("exampleFactoryName"),
 * 			ResourceGroupName:     pulumi.String("exampleResourceGroup"),
 * 			Status:                pulumi.String("Stopped"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.ChangeDataCapture;
 * import com.pulumi.azurenative.datafactory.ChangeDataCaptureArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var changeDataCapture = new ChangeDataCapture("changeDataCapture", ChangeDataCaptureArgs.builder()
 *             .allowVNetOverride(false)
 *             .changeDataCaptureName("exampleChangeDataCapture")
 *             .description("Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database. Updating table mappings.")
 *             .factoryName("exampleFactoryName")
 *             .resourceGroupName("exampleResourceGroup")
 *             .status("Stopped")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:ChangeDataCapture exampleChangeDataCapture /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/adfcdcs/{changeDataCaptureName}
 * ```
 * @property allowVNetOverride A boolean to determine if the vnet configuration needs to be overwritten.
 * @property changeDataCaptureName The change data capture name.
 * @property description The description of the change data capture.
 * @property factoryName The factory name.
 * @property folder The folder that this CDC is in. If not specified, CDC will appear at the root level.
 * @property policy CDC policy
 * @property resourceGroupName The resource group name.
 * @property sourceConnectionsInfo List of sources connections that can be used as sources in the CDC.
 * @property status Status of the CDC as to if it is running or stopped.
 * @property targetConnectionsInfo List of target connections that can be used as sources in the CDC.
 */
public data class ChangeDataCaptureArgs(
    public val allowVNetOverride: Output<Boolean>? = null,
    public val changeDataCaptureName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val factoryName: Output<String>? = null,
    public val folder: Output<ChangeDataCaptureFolderArgs>? = null,
    public val policy: Output<MapperPolicyArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceConnectionsInfo: Output<List<MapperSourceConnectionsInfoArgs>>? = null,
    public val status: Output<String>? = null,
    public val targetConnectionsInfo: Output<List<MapperTargetConnectionsInfoArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.ChangeDataCaptureArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.ChangeDataCaptureArgs =
        com.pulumi.azurenative.datafactory.ChangeDataCaptureArgs.builder()
            .allowVNetOverride(allowVNetOverride?.applyValue({ args0 -> args0 }))
            .changeDataCaptureName(changeDataCaptureName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .factoryName(factoryName?.applyValue({ args0 -> args0 }))
            .folder(folder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceConnectionsInfo(
                sourceConnectionsInfo?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .status(status?.applyValue({ args0 -> args0 }))
            .targetConnectionsInfo(
                targetConnectionsInfo?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ChangeDataCaptureArgs].
 */
@PulumiTagMarker
public class ChangeDataCaptureArgsBuilder internal constructor() {
    private var allowVNetOverride: Output<Boolean>? = null

    private var changeDataCaptureName: Output<String>? = null

    private var description: Output<String>? = null

    private var factoryName: Output<String>? = null

    private var folder: Output<ChangeDataCaptureFolderArgs>? = null

    private var policy: Output<MapperPolicyArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceConnectionsInfo: Output<List<MapperSourceConnectionsInfoArgs>>? = null

    private var status: Output<String>? = null

    private var targetConnectionsInfo: Output<List<MapperTargetConnectionsInfoArgs>>? = null

    /**
     * @param value A boolean to determine if the vnet configuration needs to be overwritten.
     */
    @JvmName("qwqfajprmudufjwy")
    public suspend fun allowVNetOverride(`value`: Output<Boolean>) {
        this.allowVNetOverride = value
    }

    /**
     * @param value The change data capture name.
     */
    @JvmName("arpresvlcwoweegv")
    public suspend fun changeDataCaptureName(`value`: Output<String>) {
        this.changeDataCaptureName = value
    }

    /**
     * @param value The description of the change data capture.
     */
    @JvmName("npoogsmxcwgjonnh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The factory name.
     */
    @JvmName("psudmjtxmjischeh")
    public suspend fun factoryName(`value`: Output<String>) {
        this.factoryName = value
    }

    /**
     * @param value The folder that this CDC is in. If not specified, CDC will appear at the root level.
     */
    @JvmName("knqoxlsinadqfexr")
    public suspend fun folder(`value`: Output<ChangeDataCaptureFolderArgs>) {
        this.folder = value
    }

    /**
     * @param value CDC policy
     */
    @JvmName("hfdlibykuuaifsca")
    public suspend fun policy(`value`: Output<MapperPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("mbhhubsviowmguma")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value List of sources connections that can be used as sources in the CDC.
     */
    @JvmName("gbnydkhkcgkqshan")
    public suspend fun sourceConnectionsInfo(`value`: Output<List<MapperSourceConnectionsInfoArgs>>) {
        this.sourceConnectionsInfo = value
    }

    @JvmName("jahdfqxsgcwdaklk")
    public suspend fun sourceConnectionsInfo(vararg values: Output<MapperSourceConnectionsInfoArgs>) {
        this.sourceConnectionsInfo = Output.all(values.asList())
    }

    /**
     * @param values List of sources connections that can be used as sources in the CDC.
     */
    @JvmName("dsofskyvimrtkpig")
    public suspend fun sourceConnectionsInfo(values: List<Output<MapperSourceConnectionsInfoArgs>>) {
        this.sourceConnectionsInfo = Output.all(values)
    }

    /**
     * @param value Status of the CDC as to if it is running or stopped.
     */
    @JvmName("hijerwqpyriapphs")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value List of target connections that can be used as sources in the CDC.
     */
    @JvmName("fboscoxoosgyivgt")
    public suspend fun targetConnectionsInfo(`value`: Output<List<MapperTargetConnectionsInfoArgs>>) {
        this.targetConnectionsInfo = value
    }

    @JvmName("wmlmqloueuyfrpsp")
    public suspend fun targetConnectionsInfo(vararg values: Output<MapperTargetConnectionsInfoArgs>) {
        this.targetConnectionsInfo = Output.all(values.asList())
    }

    /**
     * @param values List of target connections that can be used as sources in the CDC.
     */
    @JvmName("ucsvgkgincxhdtfi")
    public suspend fun targetConnectionsInfo(values: List<Output<MapperTargetConnectionsInfoArgs>>) {
        this.targetConnectionsInfo = Output.all(values)
    }

    /**
     * @param value A boolean to determine if the vnet configuration needs to be overwritten.
     */
    @JvmName("jandmaldrrtncpbh")
    public suspend fun allowVNetOverride(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowVNetOverride = mapped
    }

    /**
     * @param value The change data capture name.
     */
    @JvmName("iqkrvfymwyxkbcas")
    public suspend fun changeDataCaptureName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changeDataCaptureName = mapped
    }

    /**
     * @param value The description of the change data capture.
     */
    @JvmName("gvwhtxqkxqrerixk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The factory name.
     */
    @JvmName("ubwikvjymunvvljo")
    public suspend fun factoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.factoryName = mapped
    }

    /**
     * @param value The folder that this CDC is in. If not specified, CDC will appear at the root level.
     */
    @JvmName("tnyfukdgviytrcgc")
    public suspend fun folder(`value`: ChangeDataCaptureFolderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folder = mapped
    }

    /**
     * @param argument The folder that this CDC is in. If not specified, CDC will appear at the root level.
     */
    @JvmName("ktokahvcoflhosse")
    public suspend fun folder(argument: suspend ChangeDataCaptureFolderArgsBuilder.() -> Unit) {
        val toBeMapped = ChangeDataCaptureFolderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.folder = mapped
    }

    /**
     * @param value CDC policy
     */
    @JvmName("gnuareutrkkbngot")
    public suspend fun policy(`value`: MapperPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument CDC policy
     */
    @JvmName("dovivrakitdxbpbp")
    public suspend fun policy(argument: suspend MapperPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = MapperPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("gdttqmfdxierdupv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value List of sources connections that can be used as sources in the CDC.
     */
    @JvmName("ixnxtwewfugorgqg")
    public suspend fun sourceConnectionsInfo(`value`: List<MapperSourceConnectionsInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceConnectionsInfo = mapped
    }

    /**
     * @param argument List of sources connections that can be used as sources in the CDC.
     */
    @JvmName("nlohydjdmcelnxjf")
    public suspend
    fun sourceConnectionsInfo(argument: List<suspend MapperSourceConnectionsInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MapperSourceConnectionsInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceConnectionsInfo = mapped
    }

    /**
     * @param argument List of sources connections that can be used as sources in the CDC.
     */
    @JvmName("pjnoyykhnedrteif")
    public suspend fun sourceConnectionsInfo(
        vararg
        argument: suspend MapperSourceConnectionsInfoArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MapperSourceConnectionsInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceConnectionsInfo = mapped
    }

    /**
     * @param argument List of sources connections that can be used as sources in the CDC.
     */
    @JvmName("ngjtptrgybybdcet")
    public suspend
    fun sourceConnectionsInfo(argument: suspend MapperSourceConnectionsInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MapperSourceConnectionsInfoArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sourceConnectionsInfo = mapped
    }

    /**
     * @param values List of sources connections that can be used as sources in the CDC.
     */
    @JvmName("jjntjlytcpbhkvqj")
    public suspend fun sourceConnectionsInfo(vararg values: MapperSourceConnectionsInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionsInfo = mapped
    }

    /**
     * @param value Status of the CDC as to if it is running or stopped.
     */
    @JvmName("texfqmdkuoiwmjtk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value List of target connections that can be used as sources in the CDC.
     */
    @JvmName("tjvgsqyrnqrwnqlc")
    public suspend fun targetConnectionsInfo(`value`: List<MapperTargetConnectionsInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetConnectionsInfo = mapped
    }

    /**
     * @param argument List of target connections that can be used as sources in the CDC.
     */
    @JvmName("itrjhrrueindqnhp")
    public suspend
    fun targetConnectionsInfo(argument: List<suspend MapperTargetConnectionsInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MapperTargetConnectionsInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetConnectionsInfo = mapped
    }

    /**
     * @param argument List of target connections that can be used as sources in the CDC.
     */
    @JvmName("nrasmcyyxptaeojr")
    public suspend fun targetConnectionsInfo(
        vararg
        argument: suspend MapperTargetConnectionsInfoArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MapperTargetConnectionsInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetConnectionsInfo = mapped
    }

    /**
     * @param argument List of target connections that can be used as sources in the CDC.
     */
    @JvmName("etltwudrgqyvcmcg")
    public suspend
    fun targetConnectionsInfo(argument: suspend MapperTargetConnectionsInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MapperTargetConnectionsInfoArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targetConnectionsInfo = mapped
    }

    /**
     * @param values List of target connections that can be used as sources in the CDC.
     */
    @JvmName("pkfewsofrbdctteq")
    public suspend fun targetConnectionsInfo(vararg values: MapperTargetConnectionsInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionsInfo = mapped
    }

    internal fun build(): ChangeDataCaptureArgs = ChangeDataCaptureArgs(
        allowVNetOverride = allowVNetOverride,
        changeDataCaptureName = changeDataCaptureName,
        description = description,
        factoryName = factoryName,
        folder = folder,
        policy = policy,
        resourceGroupName = resourceGroupName,
        sourceConnectionsInfo = sourceConnectionsInfo,
        status = status,
        targetConnectionsInfo = targetConnectionsInfo,
    )
}
