@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.kotlin.outputs.ManagedIdentityCredentialResponse
import com.pulumi.azurenative.datafactory.kotlin.outputs.ManagedIdentityCredentialResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CredentialOperation].
 */
@PulumiTagMarker
public class CredentialOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CredentialOperationArgs = CredentialOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CredentialOperationArgsBuilder.() -> Unit) {
        val builder = CredentialOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CredentialOperation {
        val builtJavaResource =
            com.pulumi.azurenative.datafactory.CredentialOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CredentialOperation(builtJavaResource)
    }
}

/**
 * Credential resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### Credentials_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var credentialOperation = new AzureNative.DataFactory.CredentialOperation("credentialOperation", new()
 *     {
 *         CredentialName = "exampleCredential",
 *         FactoryName = "exampleFactoryName",
 *         Properties = new AzureNative.DataFactory.Inputs.ManagedIdentityCredentialArgs
 *         {
 *             ResourceId = "/subscriptions/12345678-1234-1234-1234-12345678abc/resourcegroups/exampleResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/exampleUami",
 *             Type = "ManagedIdentity",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datafactory.NewCredentialOperation(ctx, "credentialOperation", &datafactory.CredentialOperationArgs{
 * CredentialName: pulumi.String("exampleCredential"),
 * FactoryName: pulumi.String("exampleFactoryName"),
 * Properties: interface{}{
 * ResourceId: pulumi.String("/subscriptions/12345678-1234-1234-1234-12345678abc/resourcegroups/exampleResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/exampleUami"),
 * Type: pulumi.String("ManagedIdentity"),
 * },
 * ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.CredentialOperation;
 * import com.pulumi.azurenative.datafactory.CredentialOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var credentialOperation = new CredentialOperation("credentialOperation", CredentialOperationArgs.builder()
 *             .credentialName("exampleCredential")
 *             .factoryName("exampleFactoryName")
 *             .properties(Map.ofEntries(
 *                 Map.entry("resourceId", "/subscriptions/12345678-1234-1234-1234-12345678abc/resourcegroups/exampleResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/exampleUami"),
 *                 Map.entry("type", "ManagedIdentity")
 *             ))
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:CredentialOperation exampleCredential /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/credentials/{credentialName}
 * ```
 */
public class CredentialOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.datafactory.CredentialOperation,
) : KotlinCustomResource(javaResource, CredentialOperationMapper) {
    /**
     * Etag identifies change in the resource.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Managed Identity Credential properties.
     */
    public val properties: Output<ManagedIdentityCredentialResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CredentialOperationMapper : ResourceMapper<CredentialOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datafactory.CredentialOperation::class == javaResource::class

    override fun map(javaResource: Resource): CredentialOperation = CredentialOperation(
        javaResource
            as com.pulumi.azurenative.datafactory.CredentialOperation,
    )
}

/**
 * @see [CredentialOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CredentialOperation].
 */
public suspend fun credentialOperation(
    name: String,
    block: suspend CredentialOperationResourceBuilder.() -> Unit,
): CredentialOperation {
    val builder = CredentialOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CredentialOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun credentialOperation(name: String): CredentialOperation {
    val builder = CredentialOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
