@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.DataFlowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Data flow resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### DataFlows_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataFlow = new AzureNative.DataFactory.DataFlow("dataFlow", new()
 *     {
 *         DataFlowName = "exampleDataFlow",
 *         FactoryName = "exampleFactoryName",
 *         Properties = new AzureNative.DataFactory.Inputs.MappingDataFlowArgs
 *         {
 *             Description = "Sample demo data flow to convert currencies showing usage of union, derive and conditional split transformation.",
 *             ScriptLines = new[]
 *             {
 *                 "source(output(",
 *                 "PreviousConversionRate as double,",
 *                 "Country as string,",
 *                 "DateTime1 as string,",
 *                 "CurrentConversionRate as double",
 *                 "),",
 *                 "allowSchemaDrift: false,",
 *                 "validateSchema: false) ~> USDCurrency",
 *                 "source(output(",
 *                 "PreviousConversionRate as double,",
 *                 "Country as string,",
 *                 "DateTime1 as string,",
 *                 "CurrentConversionRate as double",
 *                 "),",
 *                 "allowSchemaDrift: true,",
 *                 "validateSchema: false) ~> CADSource",
 *                 "USDCurrency, CADSource union(byName: true)~> Union",
 *                 "Union derive(NewCurrencyRate = round(CurrentConversionRate*1.25)) ~> NewCurrencyColumn",
 *                 "NewCurrencyColumn split(Country == 'USD',",
 *                 "Country == 'CAD',disjoint: false) ~> ConditionalSplit1@(USD, CAD)",
 *                 "ConditionalSplit1@USD sink(saveMode:'overwrite' ) ~> USDSink",
 *                 "ConditionalSplit1@CAD sink(saveMode:'overwrite' ) ~> CADSink",
 *             },
 *             Sinks = new[]
 *             {
 *                 new AzureNative.DataFactory.Inputs.DataFlowSinkArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "USDOutput",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "USDSink",
 *                 },
 *                 new AzureNative.DataFactory.Inputs.DataFlowSinkArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "CADOutput",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "CADSink",
 *                 },
 *             },
 *             Sources = new[]
 *             {
 *                 new AzureNative.DataFactory.Inputs.DataFlowSourceArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "CurrencyDatasetUSD",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "USDCurrency",
 *                 },
 *                 new AzureNative.DataFactory.Inputs.DataFlowSourceArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "CurrencyDatasetCAD",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "CADSource",
 *                 },
 *             },
 *             Type = "MappingDataFlow",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewDataFlow(ctx, "dataFlow", &datafactory.DataFlowArgs{
 * 			DataFlowName: pulumi.String("exampleDataFlow"),
 * 			FactoryName:  pulumi.String("exampleFactoryName"),
 * 			Properties: datafactory.MappingDataFlow{
 * 				Description: "Sample demo data flow to convert currencies showing usage of union, derive and conditional split transformation.",
 * 				ScriptLines: []string{
 * 					"source(output(",
 * 					"PreviousConversionRate as double,",
 * 					"Country as string,",
 * 					"DateTime1 as string,",
 * 					"CurrentConversionRate as double",
 * 					"),",
 * 					"allowSchemaDrift: false,",
 * 					"validateSchema: false) ~> USDCurrency",
 * 					"source(output(",
 * 					"PreviousConversionRate as double,",
 * 					"Country as string,",
 * 					"DateTime1 as string,",
 * 					"CurrentConversionRate as double",
 * 					"),",
 * 					"allowSchemaDrift: true,",
 * 					"validateSchema: false) ~> CADSource",
 * 					"USDCurrency, CADSource union(byName: true)~> Union",
 * 					"Union derive(NewCurrencyRate = round(CurrentConversionRate*1.25)) ~> NewCurrencyColumn",
 * 					"NewCurrencyColumn split(Country == 'USD',",
 * 					"Country == 'CAD',disjoint: false) ~> ConditionalSplit1@(USD, CAD)",
 * 					"ConditionalSplit1@USD sink(saveMode:'overwrite' ) ~> USDSink",
 * 					"ConditionalSplit1@CAD sink(saveMode:'overwrite' ) ~> CADSink",
 * 				},
 * 				Sinks: []datafactory.DataFlowSink{
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "USDOutput",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "USDSink",
 * 					},
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "CADOutput",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "CADSink",
 * 					},
 * 				},
 * 				Sources: []datafactory.DataFlowSource{
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "CurrencyDatasetUSD",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "USDCurrency",
 * 					},
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "CurrencyDatasetCAD",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "CADSource",
 * 					},
 * 				},
 * 				Type: "MappingDataFlow",
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.DataFlow;
 * import com.pulumi.azurenative.datafactory.DataFlowArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataFlow = new DataFlow("dataFlow", DataFlowArgs.builder()
 *             .dataFlowName("exampleDataFlow")
 *             .factoryName("exampleFactoryName")
 *             .properties(Map.ofEntries(
 *                 Map.entry("description", "Sample demo data flow to convert currencies showing usage of union, derive and conditional split transformation."),
 *                 Map.entry("scriptLines",
 *                     "source(output(",
 *                     "PreviousConversionRate as double,",
 *                     "Country as string,",
 *                     "DateTime1 as string,",
 *                     "CurrentConversionRate as double",
 *                     "),",
 *                     "allowSchemaDrift: false,",
 *                     "validateSchema: false) ~> USDCurrency",
 *                     "source(output(",
 *                     "PreviousConversionRate as double,",
 *                     "Country as string,",
 *                     "DateTime1 as string,",
 *                     "CurrentConversionRate as double",
 *                     "),",
 *                     "allowSchemaDrift: true,",
 *                     "validateSchema: false) ~> CADSource",
 *                     "USDCurrency, CADSource union(byName: true)~> Union",
 *                     "Union derive(NewCurrencyRate = round(CurrentConversionRate*1.25)) ~> NewCurrencyColumn",
 *                     "NewCurrencyColumn split(Country == 'USD',",
 *                     "Country == 'CAD',disjoint: false) ~> ConditionalSplit1@(USD, CAD)",
 *                     "ConditionalSplit1@USD sink(saveMode:'overwrite' ) ~> USDSink",
 *                     "ConditionalSplit1@CAD sink(saveMode:'overwrite' ) ~> CADSink"),
 *                 Map.entry("sinks",
 *                     Map.ofEntries(
 *                         Map.entry("dataset", Map.ofEntries(
 *                             Map.entry("referenceName", "USDOutput"),
 *                             Map.entry("type", "DatasetReference")
 *                         )),
 *                         Map.entry("name", "USDSink")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("dataset", Map.ofEntries(
 *                             Map.entry("referenceName", "CADOutput"),
 *                             Map.entry("type", "DatasetReference")
 *                         )),
 *                         Map.entry("name", "CADSink")
 *                     )),
 *                 Map.entry("sources",
 *                     Map.ofEntries(
 *                         Map.entry("dataset", Map.ofEntries(
 *                             Map.entry("referenceName", "CurrencyDatasetUSD"),
 *                             Map.entry("type", "DatasetReference")
 *                         )),
 *                         Map.entry("name", "USDCurrency")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("dataset", Map.ofEntries(
 *                             Map.entry("referenceName", "CurrencyDatasetCAD"),
 *                             Map.entry("type", "DatasetReference")
 *                         )),
 *                         Map.entry("name", "CADSource")
 *                     )),
 *                 Map.entry("type", "MappingDataFlow")
 *             ))
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### DataFlows_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataFlow = new AzureNative.DataFactory.DataFlow("dataFlow", new()
 *     {
 *         DataFlowName = "exampleDataFlow",
 *         FactoryName = "exampleFactoryName",
 *         Properties = new AzureNative.DataFactory.Inputs.MappingDataFlowArgs
 *         {
 *             Description = "Sample demo data flow to convert currencies showing usage of union, derive and conditional split transformation.",
 *             ScriptLines = new[]
 *             {
 *                 "source(output(",
 *                 "PreviousConversionRate as double,",
 *                 "Country as string,",
 *                 "DateTime1 as string,",
 *                 "CurrentConversionRate as double",
 *                 "),",
 *                 "allowSchemaDrift: false,",
 *                 "validateSchema: false) ~> USDCurrency",
 *                 "source(output(",
 *                 "PreviousConversionRate as double,",
 *                 "Country as string,",
 *                 "DateTime1 as string,",
 *                 "CurrentConversionRate as double",
 *                 "),",
 *                 "allowSchemaDrift: true,",
 *                 "validateSchema: false) ~> CADSource",
 *                 "USDCurrency, CADSource union(byName: true)~> Union",
 *                 "Union derive(NewCurrencyRate = round(CurrentConversionRate*1.25)) ~> NewCurrencyColumn",
 *                 "NewCurrencyColumn split(Country == 'USD',",
 *                 "Country == 'CAD',disjoint: false) ~> ConditionalSplit1@(USD, CAD)",
 *                 "ConditionalSplit1@USD sink(saveMode:'overwrite' ) ~> USDSink",
 *                 "ConditionalSplit1@CAD sink(saveMode:'overwrite' ) ~> CADSink",
 *             },
 *             Sinks = new[]
 *             {
 *                 new AzureNative.DataFactory.Inputs.DataFlowSinkArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "USDOutput",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "USDSink",
 *                 },
 *                 new AzureNative.DataFactory.Inputs.DataFlowSinkArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "CADOutput",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "CADSink",
 *                 },
 *             },
 *             Sources = new[]
 *             {
 *                 new AzureNative.DataFactory.Inputs.DataFlowSourceArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "CurrencyDatasetUSD",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "USDCurrency",
 *                 },
 *                 new AzureNative.DataFactory.Inputs.DataFlowSourceArgs
 *                 {
 *                     Dataset = new AzureNative.DataFactory.Inputs.DatasetReferenceArgs
 *                     {
 *                         ReferenceName = "CurrencyDatasetCAD",
 *                         Type = "DatasetReference",
 *                     },
 *                     Name = "CADSource",
 *                 },
 *             },
 *             Type = "MappingDataFlow",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewDataFlow(ctx, "dataFlow", &datafactory.DataFlowArgs{
 * 			DataFlowName: pulumi.String("exampleDataFlow"),
 * 			FactoryName:  pulumi.String("exampleFactoryName"),
 * 			Properties: datafactory.MappingDataFlow{
 * 				Description: "Sample demo data flow to convert currencies showing usage of union, derive and conditional split transformation.",
 * 				ScriptLines: []string{
 * 					"source(output(",
 * 					"PreviousConversionRate as double,",
 * 					"Country as string,",
 * 					"DateTime1 as string,",
 * 					"CurrentConversionRate as double",
 * 					"),",
 * 					"allowSchemaDrift: false,",
 * 					"validateSchema: false) ~> USDCurrency",
 * 					"source(output(",
 * 					"PreviousConversionRate as double,",
 * 					"Country as string,",
 * 					"DateTime1 as string,",
 * 					"CurrentConversionRate as double",
 * 					"),",
 * 					"allowSchemaDrift: true,",
 * 					"validateSchema: false) ~> CADSource",
 * 					"USDCurrency, CADSource union(byName: true)~> Union",
 * 					"Union derive(NewCurrencyRate = round(CurrentConversionRate*1.25)) ~> NewCurrencyColumn",
 * 					"NewCurrencyColumn split(Country == 'USD',",
 * 					"Country == 'CAD',disjoint: false) ~> ConditionalSplit1@(USD, CAD)",
 * 					"ConditionalSplit1@USD sink(saveMode:'overwrite' ) ~> USDSink",
 * 					"ConditionalSplit1@CAD sink(saveMode:'overwrite' ) ~> CADSink",
 * 				},
 * 				Sinks: []datafactory.DataFlowSink{
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "USDOutput",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "USDSink",
 * 					},
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "CADOutput",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "CADSink",
 * 					},
 * 				},
 * 				Sources: []datafactory.DataFlowSource{
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "CurrencyDatasetUSD",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "USDCurrency",
 * 					},
 * 					{
 * 						Dataset: {
 * 							ReferenceName: "CurrencyDatasetCAD",
 * 							Type:          "DatasetReference",
 * 						},
 * 						Name: "CADSource",
 * 					},
 * 				},
 * 				Type: "MappingDataFlow",
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.DataFlow;
 * import com.pulumi.azurenative.datafactory.DataFlowArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataFlow = new DataFlow("dataFlow", DataFlowArgs.builder()
 *             .dataFlowName("exampleDataFlow")
 *             .factoryName("exampleFactoryName")
 *             .properties(Map.ofEntries(
 *                 Map.entry("description", "Sample demo data flow to convert currencies showing usage of union, derive and conditional split transformation."),
 *                 Map.entry("scriptLines",
 *                     "source(output(",
 *                     "PreviousConversionRate as double,",
 *                     "Country as string,",
 *                     "DateTime1 as string,",
 *                     "CurrentConversionRate as double",
 *                     "),",
 *                     "allowSchemaDrift: false,",
 *                     "validateSchema: false) ~> USDCurrency",
 *                     "source(output(",
 *                     "PreviousConversionRate as double,",
 *                     "Country as string,",
 *                     "DateTime1 as string,",
 *                     "CurrentConversionRate as double",
 *                     "),",
 *                     "allowSchemaDrift: true,",
 *                     "validateSchema: false) ~> CADSource",
 *                     "USDCurrency, CADSource union(byName: true)~> Union",
 *                     "Union derive(NewCurrencyRate = round(CurrentConversionRate*1.25)) ~> NewCurrencyColumn",
 *                     "NewCurrencyColumn split(Country == 'USD',",
 *                     "Country == 'CAD',disjoint: false) ~> ConditionalSplit1@(USD, CAD)",
 *                     "ConditionalSplit1@USD sink(saveMode:'overwrite' ) ~> USDSink",
 *                     "ConditionalSplit1@CAD sink(saveMode:'overwrite' ) ~> CADSink"),
 *                 Map.entry("sinks",
 *                     Map.ofEntries(
 *                         Map.entry("dataset", Map.ofEntries(
 *                             Map.entry("referenceName", "USDOutput"),
 *                             Map.entry("type", "DatasetReference")
 *                         )),
 *                         Map.entry("name", "USDSink")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("dataset", Map.ofEntries(
 *                             Map.entry("referenceName", "CADOutput"),
 *                             Map.entry("type", "DatasetReference")
 *                         )),
 *                         Map.entry("name", "CADSink")
 *                     )),
 *                 Map.entry("sources",
 *                     Map.ofEntries(
 *                         Map.entry("dataset", Map.ofEntries(
 *                             Map.entry("referenceName", "CurrencyDatasetUSD"),
 *                             Map.entry("type", "DatasetReference")
 *                         )),
 *                         Map.entry("name", "USDCurrency")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("dataset", Map.ofEntries(
 *                             Map.entry("referenceName", "CurrencyDatasetCAD"),
 *                             Map.entry("type", "DatasetReference")
 *                         )),
 *                         Map.entry("name", "CADSource")
 *                     )),
 *                 Map.entry("type", "MappingDataFlow")
 *             ))
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:DataFlow exampleDataFlow /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/dataflows/{dataFlowName}
 * ```
 * @property dataFlowName The data flow name.
 * @property factoryName The factory name.
 * @property properties Data flow properties.
 * @property resourceGroupName The resource group name.
 */
public data class DataFlowArgs(
    public val dataFlowName: Output<String>? = null,
    public val factoryName: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.DataFlowArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.DataFlowArgs =
        com.pulumi.azurenative.datafactory.DataFlowArgs.builder()
            .dataFlowName(dataFlowName?.applyValue({ args0 -> args0 }))
            .factoryName(factoryName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataFlowArgs].
 */
@PulumiTagMarker
public class DataFlowArgsBuilder internal constructor() {
    private var dataFlowName: Output<String>? = null

    private var factoryName: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The data flow name.
     */
    @JvmName("rnbhctydssaerjio")
    public suspend fun dataFlowName(`value`: Output<String>) {
        this.dataFlowName = value
    }

    /**
     * @param value The factory name.
     */
    @JvmName("riiqeiidhyvgmnlv")
    public suspend fun factoryName(`value`: Output<String>) {
        this.factoryName = value
    }

    /**
     * @param value Data flow properties.
     */
    @JvmName("ifyjrlfbmwaltxhy")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("utuvhmflmyjkeykc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The data flow name.
     */
    @JvmName("dcfjbpyhfydtfuyo")
    public suspend fun dataFlowName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFlowName = mapped
    }

    /**
     * @param value The factory name.
     */
    @JvmName("mcqfkgkiybtimgkd")
    public suspend fun factoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.factoryName = mapped
    }

    /**
     * @param value Data flow properties.
     */
    @JvmName("tsxubbpldeasmbuc")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ojtawrotdqhbxvvq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): DataFlowArgs = DataFlowArgs(
        dataFlowName = dataFlowName,
        factoryName = factoryName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
