@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.GlobalParameterArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GlobalParameterSpecificationArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GlobalParameterSpecificationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Global parameters resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### GlobalParameters_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var globalParameter = new AzureNative.DataFactory.GlobalParameter("globalParameter", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         GlobalParameterName = "default",
 *         Properties =
 *         {
 *             { "waitTime", new AzureNative.DataFactory.Inputs.GlobalParameterSpecificationArgs
 *             {
 *                 Type = "Int",
 *                 Value = 5,
 *             } },
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewGlobalParameter(ctx, "globalParameter", &datafactory.GlobalParameterArgs{
 * 			FactoryName:         pulumi.String("exampleFactoryName"),
 * 			GlobalParameterName: pulumi.String("default"),
 * 			Properties: datafactory.GlobalParameterSpecificationMap{
 * 				"waitTime": &datafactory.GlobalParameterSpecificationArgs{
 * 					Type:  pulumi.String("Int"),
 * 					Value: pulumi.Any(5),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.GlobalParameter;
 * import com.pulumi.azurenative.datafactory.GlobalParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var globalParameter = new GlobalParameter("globalParameter", GlobalParameterArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .globalParameterName("default")
 *             .properties(Map.of("waitTime", Map.ofEntries(
 *                 Map.entry("type", "Int"),
 *                 Map.entry("value", 5)
 *             )))
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### GlobalParameters_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var globalParameter = new AzureNative.DataFactory.GlobalParameter("globalParameter", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         GlobalParameterName = "default",
 *         Properties =
 *         {
 *             { "waitTime", new AzureNative.DataFactory.Inputs.GlobalParameterSpecificationArgs
 *             {
 *                 Type = "Int",
 *                 Value = 5,
 *             } },
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewGlobalParameter(ctx, "globalParameter", &datafactory.GlobalParameterArgs{
 * 			FactoryName:         pulumi.String("exampleFactoryName"),
 * 			GlobalParameterName: pulumi.String("default"),
 * 			Properties: datafactory.GlobalParameterSpecificationMap{
 * 				"waitTime": &datafactory.GlobalParameterSpecificationArgs{
 * 					Type:  pulumi.String("Int"),
 * 					Value: pulumi.Any(5),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.GlobalParameter;
 * import com.pulumi.azurenative.datafactory.GlobalParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var globalParameter = new GlobalParameter("globalParameter", GlobalParameterArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .globalParameterName("default")
 *             .properties(Map.of("waitTime", Map.ofEntries(
 *                 Map.entry("type", "Int"),
 *                 Map.entry("value", 5)
 *             )))
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:GlobalParameter default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/globalParameters/{globalParameterName}
 * ```
 * @property factoryName The factory name.
 * @property globalParameterName The global parameter name.
 * @property properties Properties of the global parameter.
 * @property resourceGroupName The resource group name.
 */
public data class GlobalParameterArgs(
    public val factoryName: Output<String>? = null,
    public val globalParameterName: Output<String>? = null,
    public val properties: Output<Map<String, GlobalParameterSpecificationArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.GlobalParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.GlobalParameterArgs =
        com.pulumi.azurenative.datafactory.GlobalParameterArgs.builder()
            .factoryName(factoryName?.applyValue({ args0 -> args0 }))
            .globalParameterName(globalParameterName?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GlobalParameterArgs].
 */
@PulumiTagMarker
public class GlobalParameterArgsBuilder internal constructor() {
    private var factoryName: Output<String>? = null

    private var globalParameterName: Output<String>? = null

    private var properties: Output<Map<String, GlobalParameterSpecificationArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The factory name.
     */
    @JvmName("xacjudisfhbyyyyg")
    public suspend fun factoryName(`value`: Output<String>) {
        this.factoryName = value
    }

    /**
     * @param value The global parameter name.
     */
    @JvmName("jmiroxjljxoaudrd")
    public suspend fun globalParameterName(`value`: Output<String>) {
        this.globalParameterName = value
    }

    /**
     * @param value Properties of the global parameter.
     */
    @JvmName("tmdyxjdkysvmftpm")
    public suspend fun properties(`value`: Output<Map<String, GlobalParameterSpecificationArgs>>) {
        this.properties = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("dblvhovkqyrxgwmp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The factory name.
     */
    @JvmName("wymsxftpdihghxie")
    public suspend fun factoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.factoryName = mapped
    }

    /**
     * @param value The global parameter name.
     */
    @JvmName("ipjylhqmrkopmfyt")
    public suspend fun globalParameterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalParameterName = mapped
    }

    /**
     * @param value Properties of the global parameter.
     */
    @JvmName("tbyevwntacwghurf")
    public suspend fun properties(`value`: Map<String, GlobalParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the global parameter.
     */
    @JvmName("hnfwlrlwrdhqhdjs")
    public suspend fun properties(
        vararg
        argument: Pair<String, suspend GlobalParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                GlobalParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param values Properties of the global parameter.
     */
    @JvmName("orustytkrkmikqny")
    public fun properties(vararg values: Pair<String, GlobalParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("acimupsyquqhurvt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): GlobalParameterArgs = GlobalParameterArgs(
        factoryName = factoryName,
        globalParameterName = globalParameterName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
