@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.IntegrationRuntimeArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.inputs.ManagedIntegrationRuntimeArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.SelfHostedIntegrationRuntimeArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Integration runtime resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### IntegrationRuntimes_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationRuntime = new AzureNative.DataFactory.IntegrationRuntime("integrationRuntime", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         IntegrationRuntimeName = "exampleIntegrationRuntime",
 *         Properties = new AzureNative.DataFactory.Inputs.SelfHostedIntegrationRuntimeArgs
 *         {
 *             Description = "A selfhosted integration runtime",
 *             Type = "SelfHosted",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewIntegrationRuntime(ctx, "integrationRuntime", &datafactory.IntegrationRuntimeArgs{
 * 			FactoryName:            pulumi.String("exampleFactoryName"),
 * 			IntegrationRuntimeName: pulumi.String("exampleIntegrationRuntime"),
 * 			Properties: datafactory.SelfHostedIntegrationRuntime{
 * 				Description: "A selfhosted integration runtime",
 * 				Type:        "SelfHosted",
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.IntegrationRuntime;
 * import com.pulumi.azurenative.datafactory.IntegrationRuntimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationRuntime = new IntegrationRuntime("integrationRuntime", IntegrationRuntimeArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .integrationRuntimeName("exampleIntegrationRuntime")
 *             .properties(Map.ofEntries(
 *                 Map.entry("description", "A selfhosted integration runtime"),
 *                 Map.entry("type", "SelfHosted")
 *             ))
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:IntegrationRuntime exampleIntegrationRuntime /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}
 * ```
 * @property factoryName The factory name.
 * @property integrationRuntimeName The integration runtime name.
 * @property properties Integration runtime properties.
 * @property resourceGroupName The resource group name.
 */
public data class IntegrationRuntimeArgs(
    public val factoryName: Output<String>? = null,
    public val integrationRuntimeName: Output<String>? = null,
    public val properties:
    Output<Either<ManagedIntegrationRuntimeArgs, SelfHostedIntegrationRuntimeArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.IntegrationRuntimeArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.IntegrationRuntimeArgs =
        com.pulumi.azurenative.datafactory.IntegrationRuntimeArgs.builder()
            .factoryName(factoryName?.applyValue({ args0 -> args0 }))
            .integrationRuntimeName(integrationRuntimeName?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationRuntimeArgs].
 */
@PulumiTagMarker
public class IntegrationRuntimeArgsBuilder internal constructor() {
    private var factoryName: Output<String>? = null

    private var integrationRuntimeName: Output<String>? = null

    private var properties:
        Output<Either<ManagedIntegrationRuntimeArgs, SelfHostedIntegrationRuntimeArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The factory name.
     */
    @JvmName("flqqjtfrvottgwer")
    public suspend fun factoryName(`value`: Output<String>) {
        this.factoryName = value
    }

    /**
     * @param value The integration runtime name.
     */
    @JvmName("mxemiliibestlsib")
    public suspend fun integrationRuntimeName(`value`: Output<String>) {
        this.integrationRuntimeName = value
    }

    /**
     * @param value Integration runtime properties.
     */
    @JvmName("pmxsoebcygdogflj")
    public suspend
    fun properties(`value`: Output<Either<ManagedIntegrationRuntimeArgs, SelfHostedIntegrationRuntimeArgs>>) {
        this.properties = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("svrousmcocvkqnwr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The factory name.
     */
    @JvmName("rjnlamqnkrnffgux")
    public suspend fun factoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.factoryName = mapped
    }

    /**
     * @param value The integration runtime name.
     */
    @JvmName("iwmddusjtbifbvhx")
    public suspend fun integrationRuntimeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationRuntimeName = mapped
    }

    /**
     * @param value Integration runtime properties.
     */
    @JvmName("pnjcvmumyuijesky")
    public suspend
    fun properties(`value`: Either<ManagedIntegrationRuntimeArgs, SelfHostedIntegrationRuntimeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Integration runtime properties.
     */
    @JvmName("xchkvxtkljuxadce")
    public fun properties(`value`: ManagedIntegrationRuntimeArgs) {
        val toBeMapped = Either.ofLeft<ManagedIntegrationRuntimeArgs,
            SelfHostedIntegrationRuntimeArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Integration runtime properties.
     */
    @JvmName("tqiwgonnpvkinedy")
    public fun properties(`value`: SelfHostedIntegrationRuntimeArgs) {
        val toBeMapped = Either.ofRight<ManagedIntegrationRuntimeArgs,
            SelfHostedIntegrationRuntimeArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("wosyoetrrevoksnd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): IntegrationRuntimeArgs = IntegrationRuntimeArgs(
        factoryName = factoryName,
        integrationRuntimeName = integrationRuntimeName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
