@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.LinkedServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Linked service resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### LinkedServices_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedService = new AzureNative.DataFactory.LinkedService("linkedService", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         LinkedServiceName = "exampleLinkedService",
 *         Properties = new AzureNative.DataFactory.Inputs.AzureStorageLinkedServiceArgs
 *         {
 *             ConnectionString =
 *             {
 *                 { "type", "SecureString" },
 *                 { "value", "DefaultEndpointsProtocol=https;AccountName=examplestorageaccount;AccountKey=<storage key>" },
 *             },
 *             Type = "AzureStorage",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewLinkedService(ctx, "linkedService", &datafactory.LinkedServiceArgs{
 * 			FactoryName:       pulumi.String("exampleFactoryName"),
 * 			LinkedServiceName: pulumi.String("exampleLinkedService"),
 * 			Properties: datafactory.AzureStorageLinkedService{
 * 				ConnectionString: map[string]interface{}{
 * 					"type":  "SecureString",
 * 					"value": "DefaultEndpointsProtocol=https;AccountName=examplestorageaccount;AccountKey=<storage key>",
 * 				},
 * 				Type: "AzureStorage",
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.LinkedService;
 * import com.pulumi.azurenative.datafactory.LinkedServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedService = new LinkedService("linkedService", LinkedServiceArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .linkedServiceName("exampleLinkedService")
 *             .properties(Map.ofEntries(
 *                 Map.entry("connectionString", AmazonMWSLinkedServiceArgs.builder()
 *                     .type("SecureString")
 *                     .value("DefaultEndpointsProtocol=https;AccountName=examplestorageaccount;AccountKey=<storage key>")
 *                     .build()),
 *                 Map.entry("type", "AzureStorage")
 *             ))
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### LinkedServices_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedService = new AzureNative.DataFactory.LinkedService("linkedService", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         LinkedServiceName = "exampleLinkedService",
 *         Properties = new AzureNative.DataFactory.Inputs.AzureStorageLinkedServiceArgs
 *         {
 *             ConnectionString =
 *             {
 *                 { "type", "SecureString" },
 *                 { "value", "DefaultEndpointsProtocol=https;AccountName=examplestorageaccount;AccountKey=<storage key>" },
 *             },
 *             Description = "Example description",
 *             Type = "AzureStorage",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewLinkedService(ctx, "linkedService", &datafactory.LinkedServiceArgs{
 * 			FactoryName:       pulumi.String("exampleFactoryName"),
 * 			LinkedServiceName: pulumi.String("exampleLinkedService"),
 * 			Properties: datafactory.AzureStorageLinkedService{
 * 				ConnectionString: map[string]interface{}{
 * 					"type":  "SecureString",
 * 					"value": "DefaultEndpointsProtocol=https;AccountName=examplestorageaccount;AccountKey=<storage key>",
 * 				},
 * 				Description: "Example description",
 * 				Type:        "AzureStorage",
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.LinkedService;
 * import com.pulumi.azurenative.datafactory.LinkedServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedService = new LinkedService("linkedService", LinkedServiceArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .linkedServiceName("exampleLinkedService")
 *             .properties(Map.ofEntries(
 *                 Map.entry("connectionString", AmazonMWSLinkedServiceArgs.builder()
 *                     .type("SecureString")
 *                     .value("DefaultEndpointsProtocol=https;AccountName=examplestorageaccount;AccountKey=<storage key>")
 *                     .build()),
 *                 Map.entry("description", "Example description"),
 *                 Map.entry("type", "AzureStorage")
 *             ))
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:LinkedService exampleLinkedService /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/linkedservices/{linkedServiceName}
 * ```
 * @property factoryName The factory name.
 * @property linkedServiceName The linked service name.
 * @property properties Properties of linked service.
 * @property resourceGroupName The resource group name.
 */
public data class LinkedServiceArgs(
    public val factoryName: Output<String>? = null,
    public val linkedServiceName: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.LinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.LinkedServiceArgs =
        com.pulumi.azurenative.datafactory.LinkedServiceArgs.builder()
            .factoryName(factoryName?.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkedServiceArgs].
 */
@PulumiTagMarker
public class LinkedServiceArgsBuilder internal constructor() {
    private var factoryName: Output<String>? = null

    private var linkedServiceName: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The factory name.
     */
    @JvmName("hmjsnmghxfsfheuu")
    public suspend fun factoryName(`value`: Output<String>) {
        this.factoryName = value
    }

    /**
     * @param value The linked service name.
     */
    @JvmName("acoeotliamlslgse")
    public suspend fun linkedServiceName(`value`: Output<String>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Properties of linked service.
     */
    @JvmName("uddvolsxnkamaswa")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("oxxlwaegpbbkqkea")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The factory name.
     */
    @JvmName("mtqavcdohmyvqqiy")
    public suspend fun factoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.factoryName = mapped
    }

    /**
     * @param value The linked service name.
     */
    @JvmName("goaueljhxylsvtmt")
    public suspend fun linkedServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param value Properties of linked service.
     */
    @JvmName("rlkpvrhlrlxbrxqe")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("eseacpminbmknbhm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): LinkedServiceArgs = LinkedServiceArgs(
        factoryName = factoryName,
        linkedServiceName = linkedServiceName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
