@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.ManagedPrivateEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Managed private endpoint resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### ManagedVirtualNetworks_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedPrivateEndpoint = new AzureNative.DataFactory.ManagedPrivateEndpoint("managedPrivateEndpoint", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         ManagedPrivateEndpointName = "exampleManagedPrivateEndpointName",
 *         ManagedVirtualNetworkName = "exampleManagedVirtualNetworkName",
 *         Properties = new AzureNative.DataFactory.Inputs.ManagedPrivateEndpointArgs
 *         {
 *             Fqdns = new() { },
 *             GroupId = "blob",
 *             PrivateLinkResourceId = "/subscriptions/12345678-1234-1234-1234-12345678abc/resourceGroups/exampleResourceGroup/providers/Microsoft.Storage/storageAccounts/exampleBlobStorage",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewManagedPrivateEndpoint(ctx, "managedPrivateEndpoint", &datafactory.ManagedPrivateEndpointArgs{
 * 			FactoryName:                pulumi.String("exampleFactoryName"),
 * 			ManagedPrivateEndpointName: pulumi.String("exampleManagedPrivateEndpointName"),
 * 			ManagedVirtualNetworkName:  pulumi.String("exampleManagedVirtualNetworkName"),
 * 			Properties: &datafactory.ManagedPrivateEndpointTypeArgs{
 * 				Fqdns:                 pulumi.StringArray{},
 * 				GroupId:               pulumi.String("blob"),
 * 				PrivateLinkResourceId: pulumi.String("/subscriptions/12345678-1234-1234-1234-12345678abc/resourceGroups/exampleResourceGroup/providers/Microsoft.Storage/storageAccounts/exampleBlobStorage"),
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.ManagedPrivateEndpoint;
 * import com.pulumi.azurenative.datafactory.ManagedPrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedPrivateEndpoint = new ManagedPrivateEndpoint("managedPrivateEndpoint", ManagedPrivateEndpointArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .managedPrivateEndpointName("exampleManagedPrivateEndpointName")
 *             .managedVirtualNetworkName("exampleManagedVirtualNetworkName")
 *             .properties(Map.ofEntries(
 *                 Map.entry("fqdns", ),
 *                 Map.entry("groupId", "blob"),
 *                 Map.entry("privateLinkResourceId", "/subscriptions/12345678-1234-1234-1234-12345678abc/resourceGroups/exampleResourceGroup/providers/Microsoft.Storage/storageAccounts/exampleBlobStorage")
 *             ))
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:ManagedPrivateEndpoint exampleManagedPrivateEndpointName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/managedVirtualNetworks/{managedVirtualNetworkName}/managedPrivateEndpoints/{managedPrivateEndpointName}
 * ```
 * @property factoryName The factory name.
 * @property managedPrivateEndpointName Managed private endpoint name
 * @property managedVirtualNetworkName Managed virtual network name
 * @property properties Managed private endpoint properties.
 * @property resourceGroupName The resource group name.
 */
public data class ManagedPrivateEndpointArgs(
    public val factoryName: Output<String>? = null,
    public val managedPrivateEndpointName: Output<String>? = null,
    public val managedVirtualNetworkName: Output<String>? = null,
    public val properties:
    Output<com.pulumi.azurenative.datafactory.kotlin.inputs.ManagedPrivateEndpointArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.ManagedPrivateEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.ManagedPrivateEndpointArgs =
        com.pulumi.azurenative.datafactory.ManagedPrivateEndpointArgs.builder()
            .factoryName(factoryName?.applyValue({ args0 -> args0 }))
            .managedPrivateEndpointName(managedPrivateEndpointName?.applyValue({ args0 -> args0 }))
            .managedVirtualNetworkName(managedVirtualNetworkName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedPrivateEndpointArgs].
 */
@PulumiTagMarker
public class ManagedPrivateEndpointArgsBuilder internal constructor() {
    private var factoryName: Output<String>? = null

    private var managedPrivateEndpointName: Output<String>? = null

    private var managedVirtualNetworkName: Output<String>? = null

    private var properties:
        Output<com.pulumi.azurenative.datafactory.kotlin.inputs.ManagedPrivateEndpointArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The factory name.
     */
    @JvmName("qvpbwpcefxppcmoj")
    public suspend fun factoryName(`value`: Output<String>) {
        this.factoryName = value
    }

    /**
     * @param value Managed private endpoint name
     */
    @JvmName("hdebhlnxumrtvdpy")
    public suspend fun managedPrivateEndpointName(`value`: Output<String>) {
        this.managedPrivateEndpointName = value
    }

    /**
     * @param value Managed virtual network name
     */
    @JvmName("wcsikxcyalioytmw")
    public suspend fun managedVirtualNetworkName(`value`: Output<String>) {
        this.managedVirtualNetworkName = value
    }

    /**
     * @param value Managed private endpoint properties.
     */
    @JvmName("lurmmkuwjacqmuhp")
    public suspend
    fun properties(`value`: Output<com.pulumi.azurenative.datafactory.kotlin.inputs.ManagedPrivateEndpointArgs>) {
        this.properties = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("jblofbnvpfeyrcws")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The factory name.
     */
    @JvmName("fvncjnlquealpsve")
    public suspend fun factoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.factoryName = mapped
    }

    /**
     * @param value Managed private endpoint name
     */
    @JvmName("idjenddqvnmqbbrl")
    public suspend fun managedPrivateEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedPrivateEndpointName = mapped
    }

    /**
     * @param value Managed virtual network name
     */
    @JvmName("rdyibvdmealcydbd")
    public suspend fun managedVirtualNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedVirtualNetworkName = mapped
    }

    /**
     * @param value Managed private endpoint properties.
     */
    @JvmName("vsglptogjqaffgxk")
    public suspend
    fun properties(`value`: com.pulumi.azurenative.datafactory.kotlin.inputs.ManagedPrivateEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Managed private endpoint properties.
     */
    @JvmName("opsbkdoyvdragtud")
    public suspend
    fun properties(argument: suspend com.pulumi.azurenative.datafactory.kotlin.inputs.ManagedPrivateEndpointArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.datafactory.kotlin.inputs.ManagedPrivateEndpointArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("jkovfdgcfsldscpp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ManagedPrivateEndpointArgs = ManagedPrivateEndpointArgs(
        factoryName = factoryName,
        managedPrivateEndpointName = managedPrivateEndpointName,
        managedVirtualNetworkName = managedVirtualNetworkName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
