@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Activity state. This is an optional property and if not provided, the state will be Active by default.
 */
public enum class ActivityState(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.ActivityState,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.ActivityState> {
    Active(com.pulumi.azurenative.datafactory.enums.ActivityState.Active),
    Inactive(com.pulumi.azurenative.datafactory.enums.ActivityState.Inactive),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.ActivityState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.ActivityState):
            ActivityState = ActivityState.values().first { it.javaValue == javaType }
    }
}
