@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of the CDC attribute mapping. Note: 'Advanced' mapping type is also saved as 'Derived'.
 */
public enum class MappingType(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.MappingType,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.MappingType> {
    Direct(com.pulumi.azurenative.datafactory.enums.MappingType.Direct),
    Derived(com.pulumi.azurenative.datafactory.enums.MappingType.Derived),
    Aggregate(com.pulumi.azurenative.datafactory.enums.MappingType.Aggregate),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.MappingType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.MappingType): MappingType =
            MappingType.values().first { it.javaValue == javaType }
    }
}
