@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ActivityDependencyArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.DependencyCondition
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Activity dependency information.
 * @property activity Activity name.
 * @property dependencyConditions Match-Condition for the dependency.
 */
public data class ActivityDependencyArgs(
    public val activity: Output<String>,
    public val dependencyConditions: Output<List<Either<String, DependencyCondition>>>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ActivityDependencyArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ActivityDependencyArgs =
        com.pulumi.azurenative.datafactory.inputs.ActivityDependencyArgs.builder()
            .activity(activity.applyValue({ args0 -> args0 }))
            .dependencyConditions(
                dependencyConditions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ActivityDependencyArgs].
 */
@PulumiTagMarker
public class ActivityDependencyArgsBuilder internal constructor() {
    private var activity: Output<String>? = null

    private var dependencyConditions: Output<List<Either<String, DependencyCondition>>>? = null

    /**
     * @param value Activity name.
     */
    @JvmName("iaotgywgdvvspfan")
    public suspend fun activity(`value`: Output<String>) {
        this.activity = value
    }

    /**
     * @param value Match-Condition for the dependency.
     */
    @JvmName("rbtpilkibakxopkg")
    public suspend
    fun dependencyConditions(`value`: Output<List<Either<String, DependencyCondition>>>) {
        this.dependencyConditions = value
    }

    @JvmName("dhwvgjptlrtlxjko")
    public suspend fun dependencyConditions(
        vararg
        values: Output<Either<String, DependencyCondition>>,
    ) {
        this.dependencyConditions = Output.all(values.asList())
    }

    /**
     * @param values Match-Condition for the dependency.
     */
    @JvmName("hgldgfmeayjpvjej")
    public suspend
    fun dependencyConditions(values: List<Output<Either<String, DependencyCondition>>>) {
        this.dependencyConditions = Output.all(values)
    }

    /**
     * @param value Activity name.
     */
    @JvmName("gxhssxdihvnknllj")
    public suspend fun activity(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activity = mapped
    }

    /**
     * @param value Match-Condition for the dependency.
     */
    @JvmName("ohpgacmjkqbwlyjv")
    public suspend fun dependencyConditions(`value`: List<Either<String, DependencyCondition>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependencyConditions = mapped
    }

    /**
     * @param values Match-Condition for the dependency.
     */
    @JvmName("ivdyhnaormvdnrnj")
    public suspend fun dependencyConditions(vararg values: Either<String, DependencyCondition>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependencyConditions = mapped
    }

    internal fun build(): ActivityDependencyArgs = ActivityDependencyArgs(
        activity = activity ?: throw PulumiNullFieldException("activity"),
        dependencyConditions = dependencyConditions ?: throw
            PulumiNullFieldException("dependencyConditions"),
    )
}
