@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AmazonRdsForOraclePartitionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The settings that will be leveraged for AmazonRdsForOracle source partitioning.
 * @property partitionColumnName The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 * @property partitionLowerBound The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 * @property partitionNames Names of the physical partitions of AmazonRdsForOracle table.
 * @property partitionUpperBound The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
 */
public data class AmazonRdsForOraclePartitionSettingsArgs(
    public val partitionColumnName: Output<Any>? = null,
    public val partitionLowerBound: Output<Any>? = null,
    public val partitionNames: Output<List<Any>>? = null,
    public val partitionUpperBound: Output<Any>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AmazonRdsForOraclePartitionSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.AmazonRdsForOraclePartitionSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.AmazonRdsForOraclePartitionSettingsArgs.builder()
            .partitionColumnName(partitionColumnName?.applyValue({ args0 -> args0 }))
            .partitionLowerBound(partitionLowerBound?.applyValue({ args0 -> args0 }))
            .partitionNames(partitionNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .partitionUpperBound(partitionUpperBound?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmazonRdsForOraclePartitionSettingsArgs].
 */
@PulumiTagMarker
public class AmazonRdsForOraclePartitionSettingsArgsBuilder internal constructor() {
    private var partitionColumnName: Output<Any>? = null

    private var partitionLowerBound: Output<Any>? = null

    private var partitionNames: Output<List<Any>>? = null

    private var partitionUpperBound: Output<Any>? = null

    /**
     * @param value The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("relwgbkmdstxcuxl")
    public suspend fun partitionColumnName(`value`: Output<Any>) {
        this.partitionColumnName = value
    }

    /**
     * @param value The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("bcxjogmkduthjsom")
    public suspend fun partitionLowerBound(`value`: Output<Any>) {
        this.partitionLowerBound = value
    }

    /**
     * @param value Names of the physical partitions of AmazonRdsForOracle table.
     */
    @JvmName("kdsvbhaohnqgtgul")
    public suspend fun partitionNames(`value`: Output<List<Any>>) {
        this.partitionNames = value
    }

    @JvmName("vvhmgtfxsasbrjlg")
    public suspend fun partitionNames(vararg values: Output<Any>) {
        this.partitionNames = Output.all(values.asList())
    }

    /**
     * @param values Names of the physical partitions of AmazonRdsForOracle table.
     */
    @JvmName("fimarirxmusnuavk")
    public suspend fun partitionNames(values: List<Output<Any>>) {
        this.partitionNames = Output.all(values)
    }

    /**
     * @param value The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("baympejcpvywqshp")
    public suspend fun partitionUpperBound(`value`: Output<Any>) {
        this.partitionUpperBound = value
    }

    /**
     * @param value The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("jempdsueeoyvgeem")
    public suspend fun partitionColumnName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionColumnName = mapped
    }

    /**
     * @param value The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("qxndmvyfcgsiuixm")
    public suspend fun partitionLowerBound(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionLowerBound = mapped
    }

    /**
     * @param value Names of the physical partitions of AmazonRdsForOracle table.
     */
    @JvmName("cwomwafiexatxmqi")
    public suspend fun partitionNames(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionNames = mapped
    }

    /**
     * @param values Names of the physical partitions of AmazonRdsForOracle table.
     */
    @JvmName("yopumpnnhqnbwrnn")
    public suspend fun partitionNames(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionNames = mapped
    }

    /**
     * @param value The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type: string (or Expression with resultType string).
     */
    @JvmName("tjrqgpwokjsfwsew")
    public suspend fun partitionUpperBound(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionUpperBound = mapped
    }

    internal fun build(): AmazonRdsForOraclePartitionSettingsArgs =
        AmazonRdsForOraclePartitionSettingsArgs(
            partitionColumnName = partitionColumnName,
            partitionLowerBound = partitionLowerBound,
            partitionNames = partitionNames,
            partitionUpperBound = partitionUpperBound,
        )
}
