@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureBlobFSWriteSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure blobFS write settings.
 * @property blockSizeInMB Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer).
 * @property copyBehavior The type of copy behavior for copy sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property metadata Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
 * @property type The write setting type.
 * Expected value is 'AzureBlobFSWriteSettings'.
 */
public data class AzureBlobFSWriteSettingsArgs(
    public val blockSizeInMB: Output<Any>? = null,
    public val copyBehavior: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val metadata: Output<List<MetadataItemArgs>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureBlobFSWriteSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureBlobFSWriteSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureBlobFSWriteSettingsArgs.builder()
            .blockSizeInMB(blockSizeInMB?.applyValue({ args0 -> args0 }))
            .copyBehavior(copyBehavior?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureBlobFSWriteSettingsArgs].
 */
@PulumiTagMarker
public class AzureBlobFSWriteSettingsArgsBuilder internal constructor() {
    private var blockSizeInMB: Output<Any>? = null

    private var copyBehavior: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var metadata: Output<List<MetadataItemArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer).
     */
    @JvmName("jqarepudhgjmdrni")
    public suspend fun blockSizeInMB(`value`: Output<Any>) {
        this.blockSizeInMB = value
    }

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("khmtwwqpklqdfcgs")
    public suspend fun copyBehavior(`value`: Output<Any>) {
        this.copyBehavior = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("sydgahbfadprufyp")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("fvlnavcshhyawdrh")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("lllfxekrqegplyqt")
    public suspend fun metadata(`value`: Output<List<MetadataItemArgs>>) {
        this.metadata = value
    }

    @JvmName("ujcldwuaehjqcylr")
    public suspend fun metadata(vararg values: Output<MetadataItemArgs>) {
        this.metadata = Output.all(values.asList())
    }

    /**
     * @param values Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("vwxwfhweuabevrll")
    public suspend fun metadata(values: List<Output<MetadataItemArgs>>) {
        this.metadata = Output.all(values)
    }

    /**
     * @param value The write setting type.
     * Expected value is 'AzureBlobFSWriteSettings'.
     */
    @JvmName("krrqokyicucojcyj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer).
     */
    @JvmName("jwuuqlavjbevceft")
    public suspend fun blockSizeInMB(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockSizeInMB = mapped
    }

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("ayyuhnytmqoiraxh")
    public suspend fun copyBehavior(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyBehavior = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ekacoqwxlvsvgoqa")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("oblpblkjhsqigocq")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("uymifnqdiogrsvdr")
    public suspend fun metadata(`value`: List<MetadataItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param argument Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("ytqaaufixbvqjmqr")
    public suspend fun metadata(argument: List<suspend MetadataItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetadataItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("upkmjskqghveupml")
    public suspend fun metadata(vararg argument: suspend MetadataItemArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetadataItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("ucxmycyklpggaswn")
    public suspend fun metadata(argument: suspend MetadataItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetadataItemArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param values Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("bttjmedfcmwclvbd")
    public suspend fun metadata(vararg values: MetadataItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The write setting type.
     * Expected value is 'AzureBlobFSWriteSettings'.
     */
    @JvmName("ndnkichlfngqitgu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureBlobFSWriteSettingsArgs = AzureBlobFSWriteSettingsArgs(
        blockSizeInMB = blockSizeInMB,
        copyBehavior = copyBehavior,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        metadata = metadata,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
