@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureBlobStorageLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The location of azure blob dataset.
 * @property container Specify the container of azure blob. Type: string (or Expression with resultType string).
 * @property fileName Specify the file name of dataset. Type: string (or Expression with resultType string).
 * @property folderPath Specify the folder path of dataset. Type: string (or Expression with resultType string)
 * @property type Type of dataset storage location.
 * Expected value is 'AzureBlobStorageLocation'.
 */
public data class AzureBlobStorageLocationArgs(
    public val container: Output<Any>? = null,
    public val fileName: Output<Any>? = null,
    public val folderPath: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureBlobStorageLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureBlobStorageLocationArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureBlobStorageLocationArgs.builder()
            .container(container?.applyValue({ args0 -> args0 }))
            .fileName(fileName?.applyValue({ args0 -> args0 }))
            .folderPath(folderPath?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureBlobStorageLocationArgs].
 */
@PulumiTagMarker
public class AzureBlobStorageLocationArgsBuilder internal constructor() {
    private var container: Output<Any>? = null

    private var fileName: Output<Any>? = null

    private var folderPath: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specify the container of azure blob. Type: string (or Expression with resultType string).
     */
    @JvmName("mnxmmdpmjfhxxvpy")
    public suspend fun container(`value`: Output<Any>) {
        this.container = value
    }

    /**
     * @param value Specify the file name of dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("ahyernbgyyytyntu")
    public suspend fun fileName(`value`: Output<Any>) {
        this.fileName = value
    }

    /**
     * @param value Specify the folder path of dataset. Type: string (or Expression with resultType string)
     */
    @JvmName("fuhljwweadggeqfm")
    public suspend fun folderPath(`value`: Output<Any>) {
        this.folderPath = value
    }

    /**
     * @param value Type of dataset storage location.
     * Expected value is 'AzureBlobStorageLocation'.
     */
    @JvmName("bvtevcftnyxbuwpo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specify the container of azure blob. Type: string (or Expression with resultType string).
     */
    @JvmName("vksydvldwexirshk")
    public suspend fun container(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.container = mapped
    }

    /**
     * @param value Specify the file name of dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("ugryqjwunnukhyfc")
    public suspend fun fileName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileName = mapped
    }

    /**
     * @param value Specify the folder path of dataset. Type: string (or Expression with resultType string)
     */
    @JvmName("lcltvlhatdhcqvpc")
    public suspend fun folderPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value Type of dataset storage location.
     * Expected value is 'AzureBlobStorageLocation'.
     */
    @JvmName("avwdhtwnxnxjqnsd")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureBlobStorageLocationArgs = AzureBlobStorageLocationArgs(
        container = container,
        fileName = fileName,
        folderPath = folderPath,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
