@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureDataLakeStoreWriteSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure data lake store write settings.
 * @property copyBehavior The type of copy behavior for copy sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property expiryDateTime Specifies the expiry time of the written files. The time is applied to the UTC time zone in the format of "2018-12-01T05:00:00Z". Default value is NULL. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property metadata Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
 * @property type The write setting type.
 * Expected value is 'AzureDataLakeStoreWriteSettings'.
 */
public data class AzureDataLakeStoreWriteSettingsArgs(
    public val copyBehavior: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val expiryDateTime: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val metadata: Output<List<MetadataItemArgs>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureDataLakeStoreWriteSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.AzureDataLakeStoreWriteSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureDataLakeStoreWriteSettingsArgs.builder()
            .copyBehavior(copyBehavior?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .expiryDateTime(expiryDateTime?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureDataLakeStoreWriteSettingsArgs].
 */
@PulumiTagMarker
public class AzureDataLakeStoreWriteSettingsArgsBuilder internal constructor() {
    private var copyBehavior: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var expiryDateTime: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var metadata: Output<List<MetadataItemArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("jyvrxpvttbrjwgjk")
    public suspend fun copyBehavior(`value`: Output<Any>) {
        this.copyBehavior = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("falbofppslwawxfm")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value Specifies the expiry time of the written files. The time is applied to the UTC time zone in the format of "2018-12-01T05:00:00Z". Default value is NULL. Type: string (or Expression with resultType string).
     */
    @JvmName("rkyaksddmxtuoujp")
    public suspend fun expiryDateTime(`value`: Output<Any>) {
        this.expiryDateTime = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ugxubjsoayirknsl")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("utnhblaxjumnulul")
    public suspend fun metadata(`value`: Output<List<MetadataItemArgs>>) {
        this.metadata = value
    }

    @JvmName("tostsdyqvwtpnnlg")
    public suspend fun metadata(vararg values: Output<MetadataItemArgs>) {
        this.metadata = Output.all(values.asList())
    }

    /**
     * @param values Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("ppxkgbwycbfshhav")
    public suspend fun metadata(values: List<Output<MetadataItemArgs>>) {
        this.metadata = Output.all(values)
    }

    /**
     * @param value The write setting type.
     * Expected value is 'AzureDataLakeStoreWriteSettings'.
     */
    @JvmName("ldsipvdgmgrkelbw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("dmgqkchprdloupmf")
    public suspend fun copyBehavior(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyBehavior = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("nptvtqhuodjrfogc")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value Specifies the expiry time of the written files. The time is applied to the UTC time zone in the format of "2018-12-01T05:00:00Z". Default value is NULL. Type: string (or Expression with resultType string).
     */
    @JvmName("siyldwyryovnkyjm")
    public suspend fun expiryDateTime(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiryDateTime = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("vxrqnoeilcmvqrdj")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("pgcpduhfqjbhdbuu")
    public suspend fun metadata(`value`: List<MetadataItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param argument Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("bcuvqwigitldxgcc")
    public suspend fun metadata(argument: List<suspend MetadataItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetadataItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("iffmracasmvchvqt")
    public suspend fun metadata(vararg argument: suspend MetadataItemArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetadataItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("fsvnendkqtttwlcr")
    public suspend fun metadata(argument: suspend MetadataItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetadataItemArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param values Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("qdqqcgwtulhxqegj")
    public suspend fun metadata(vararg values: MetadataItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The write setting type.
     * Expected value is 'AzureDataLakeStoreWriteSettings'.
     */
    @JvmName("ehychkdnxwgfhdqe")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureDataLakeStoreWriteSettingsArgs = AzureDataLakeStoreWriteSettingsArgs(
        copyBehavior = copyBehavior,
        disableMetricsCollection = disableMetricsCollection,
        expiryDateTime = expiryDateTime,
        maxConcurrentConnections = maxConcurrentConnections,
        metadata = metadata,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
