@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureDatabricksLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure Databricks linked service.
 * @property accessToken Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authentication Required to specify MSI, if using Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property credential The credential reference containing authentication information.
 * @property description Linked service description.
 * @property domain <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property existingClusterId The id of an existing interactive cluster that will be used for all runs of this activity. Type: string (or Expression with resultType string).
 * @property instancePoolId The id of an existing instance pool that will be used for all runs of this activity. Type: string (or Expression with resultType string).
 * @property newClusterCustomTags Additional tags for cluster resources. This property is ignored in instance pool configurations.
 * @property newClusterDriverNodeType The driver node type for the new job cluster. This property is ignored in instance pool configurations. Type: string (or Expression with resultType string).
 * @property newClusterEnableElasticDisk Enable the elastic disk on the new cluster. This property is now ignored, and takes the default elastic disk behavior in Databricks (elastic disks are always enabled). Type: boolean (or Expression with resultType boolean).
 * @property newClusterInitScripts User-defined initialization scripts for the new cluster. Type: array of strings (or Expression with resultType array of strings).
 * @property newClusterLogDestination Specify a location to deliver Spark driver, worker, and event logs. Type: string (or Expression with resultType string).
 * @property newClusterNodeType The node type of the new job cluster. This property is required if newClusterVersion is specified and instancePoolId is not specified. If instancePoolId is specified, this property is ignored. Type: string (or Expression with resultType string).
 * @property newClusterNumOfWorker If not using an existing interactive cluster, this specifies the number of worker nodes to use for the new job cluster or instance pool. For new job clusters, this a string-formatted Int32, like '1' means numOfWorker is 1 or '1:10' means auto-scale from 1 (min) to 10 (max). For instance pools, this is a string-formatted Int32, and can only specify a fixed number of worker nodes, such as '2'. Required if newClusterVersion is specified. Type: string (or Expression with resultType string).
 * @property newClusterSparkConf A set of optional, user-specified Spark configuration key-value pairs.
 * @property newClusterSparkEnvVars A set of optional, user-specified Spark environment variables key-value pairs.
 * @property newClusterVersion If not using an existing interactive cluster, this specifies the Spark version of a new job cluster or instance pool nodes created for each run of this activity. Required if instancePoolId is specified. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property policyId The policy id for limiting the ability to configure clusters based on a user defined set of rules. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'AzureDatabricks'.
 * @property workspaceResourceId Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
 */
public data class AzureDatabricksLinkedServiceArgs(
    public val accessToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val annotations: Output<List<Any>>? = null,
    public val authentication: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val credential: Output<CredentialReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val domain: Output<Any>,
    public val encryptedCredential: Output<String>? = null,
    public val existingClusterId: Output<Any>? = null,
    public val instancePoolId: Output<Any>? = null,
    public val newClusterCustomTags: Output<Map<String, Any>>? = null,
    public val newClusterDriverNodeType: Output<Any>? = null,
    public val newClusterEnableElasticDisk: Output<Any>? = null,
    public val newClusterInitScripts: Output<Any>? = null,
    public val newClusterLogDestination: Output<Any>? = null,
    public val newClusterNodeType: Output<Any>? = null,
    public val newClusterNumOfWorker: Output<Any>? = null,
    public val newClusterSparkConf: Output<Map<String, Any>>? = null,
    public val newClusterSparkEnvVars: Output<Map<String, Any>>? = null,
    public val newClusterVersion: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val policyId: Output<Any>? = null,
    public val type: Output<String>,
    public val workspaceResourceId: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureDatabricksLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureDatabricksLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureDatabricksLinkedServiceArgs.builder()
            .accessToken(
                accessToken?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authentication(authentication?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .domain(domain.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .existingClusterId(existingClusterId?.applyValue({ args0 -> args0 }))
            .instancePoolId(instancePoolId?.applyValue({ args0 -> args0 }))
            .newClusterCustomTags(
                newClusterCustomTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .newClusterDriverNodeType(newClusterDriverNodeType?.applyValue({ args0 -> args0 }))
            .newClusterEnableElasticDisk(newClusterEnableElasticDisk?.applyValue({ args0 -> args0 }))
            .newClusterInitScripts(newClusterInitScripts?.applyValue({ args0 -> args0 }))
            .newClusterLogDestination(newClusterLogDestination?.applyValue({ args0 -> args0 }))
            .newClusterNodeType(newClusterNodeType?.applyValue({ args0 -> args0 }))
            .newClusterNumOfWorker(newClusterNumOfWorker?.applyValue({ args0 -> args0 }))
            .newClusterSparkConf(
                newClusterSparkConf?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .newClusterSparkEnvVars(
                newClusterSparkEnvVars?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .newClusterVersion(newClusterVersion?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .workspaceResourceId(workspaceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureDatabricksLinkedServiceArgs].
 */
@PulumiTagMarker
public class AzureDatabricksLinkedServiceArgsBuilder internal constructor() {
    private var accessToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var annotations: Output<List<Any>>? = null

    private var authentication: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var credential: Output<CredentialReferenceArgs>? = null

    private var description: Output<String>? = null

    private var domain: Output<Any>? = null

    private var encryptedCredential: Output<String>? = null

    private var existingClusterId: Output<Any>? = null

    private var instancePoolId: Output<Any>? = null

    private var newClusterCustomTags: Output<Map<String, Any>>? = null

    private var newClusterDriverNodeType: Output<Any>? = null

    private var newClusterEnableElasticDisk: Output<Any>? = null

    private var newClusterInitScripts: Output<Any>? = null

    private var newClusterLogDestination: Output<Any>? = null

    private var newClusterNodeType: Output<Any>? = null

    private var newClusterNumOfWorker: Output<Any>? = null

    private var newClusterSparkConf: Output<Map<String, Any>>? = null

    private var newClusterSparkEnvVars: Output<Map<String, Any>>? = null

    private var newClusterVersion: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var policyId: Output<Any>? = null

    private var type: Output<String>? = null

    private var workspaceResourceId: Output<Any>? = null

    /**
     * @param value Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression with resultType string).
     */
    @JvmName("wearbgpyfawqrbql")
    public suspend
    fun accessToken(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.accessToken = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("xxoggoiaidvnkxcg")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("iitoechoxetbshsj")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("ictxcuypiyhwpnji")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Required to specify MSI, if using Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
     */
    @JvmName("ynaovqneqcujvbtq")
    public suspend fun authentication(`value`: Output<Any>) {
        this.authentication = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("hapksbtjhariyyyq")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("fodgqhgihucgxwuy")
    public suspend fun credential(`value`: Output<CredentialReferenceArgs>) {
        this.credential = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("kyflpgliithyoyag")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
     */
    @JvmName("ugixadtwpgnxetsk")
    public suspend fun domain(`value`: Output<Any>) {
        this.domain = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("fegubbpkjyafgimy")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The id of an existing interactive cluster that will be used for all runs of this activity. Type: string (or Expression with resultType string).
     */
    @JvmName("nobimsnfcaggcyvb")
    public suspend fun existingClusterId(`value`: Output<Any>) {
        this.existingClusterId = value
    }

    /**
     * @param value The id of an existing instance pool that will be used for all runs of this activity. Type: string (or Expression with resultType string).
     */
    @JvmName("curmcxqdskpkqllq")
    public suspend fun instancePoolId(`value`: Output<Any>) {
        this.instancePoolId = value
    }

    /**
     * @param value Additional tags for cluster resources. This property is ignored in instance pool configurations.
     */
    @JvmName("cjbiphsnvwdbmmkv")
    public suspend fun newClusterCustomTags(`value`: Output<Map<String, Any>>) {
        this.newClusterCustomTags = value
    }

    /**
     * @param value The driver node type for the new job cluster. This property is ignored in instance pool configurations. Type: string (or Expression with resultType string).
     */
    @JvmName("cwlasnqpvkrbjtlt")
    public suspend fun newClusterDriverNodeType(`value`: Output<Any>) {
        this.newClusterDriverNodeType = value
    }

    /**
     * @param value Enable the elastic disk on the new cluster. This property is now ignored, and takes the default elastic disk behavior in Databricks (elastic disks are always enabled). Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("xkbjwxjnbqlrffxm")
    public suspend fun newClusterEnableElasticDisk(`value`: Output<Any>) {
        this.newClusterEnableElasticDisk = value
    }

    /**
     * @param value User-defined initialization scripts for the new cluster. Type: array of strings (or Expression with resultType array of strings).
     */
    @JvmName("nbwaqhplcqjluijm")
    public suspend fun newClusterInitScripts(`value`: Output<Any>) {
        this.newClusterInitScripts = value
    }

    /**
     * @param value Specify a location to deliver Spark driver, worker, and event logs. Type: string (or Expression with resultType string).
     */
    @JvmName("wevukthhxbpocwyg")
    public suspend fun newClusterLogDestination(`value`: Output<Any>) {
        this.newClusterLogDestination = value
    }

    /**
     * @param value The node type of the new job cluster. This property is required if newClusterVersion is specified and instancePoolId is not specified. If instancePoolId is specified, this property is ignored. Type: string (or Expression with resultType string).
     */
    @JvmName("xksvkgxkavwmhobn")
    public suspend fun newClusterNodeType(`value`: Output<Any>) {
        this.newClusterNodeType = value
    }

    /**
     * @param value If not using an existing interactive cluster, this specifies the number of worker nodes to use for the new job cluster or instance pool. For new job clusters, this a string-formatted Int32, like '1' means numOfWorker is 1 or '1:10' means auto-scale from 1 (min) to 10 (max). For instance pools, this is a string-formatted Int32, and can only specify a fixed number of worker nodes, such as '2'. Required if newClusterVersion is specified. Type: string (or Expression with resultType string).
     */
    @JvmName("gdmrxoqrphymdvnw")
    public suspend fun newClusterNumOfWorker(`value`: Output<Any>) {
        this.newClusterNumOfWorker = value
    }

    /**
     * @param value A set of optional, user-specified Spark configuration key-value pairs.
     */
    @JvmName("baggswpbfpmfwbvq")
    public suspend fun newClusterSparkConf(`value`: Output<Map<String, Any>>) {
        this.newClusterSparkConf = value
    }

    /**
     * @param value A set of optional, user-specified Spark environment variables key-value pairs.
     */
    @JvmName("wlbhbjudupaesaab")
    public suspend fun newClusterSparkEnvVars(`value`: Output<Map<String, Any>>) {
        this.newClusterSparkEnvVars = value
    }

    /**
     * @param value If not using an existing interactive cluster, this specifies the Spark version of a new job cluster or instance pool nodes created for each run of this activity. Required if instancePoolId is specified. Type: string (or Expression with resultType string).
     */
    @JvmName("mexftekrgqiepvyr")
    public suspend fun newClusterVersion(`value`: Output<Any>) {
        this.newClusterVersion = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("gidumpqasnqxppuf")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The policy id for limiting the ability to configure clusters based on a user defined set of rules. Type: string (or Expression with resultType string).
     */
    @JvmName("dudaxskextranops")
    public suspend fun policyId(`value`: Output<Any>) {
        this.policyId = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureDatabricks'.
     */
    @JvmName("yfjxpbrodjprrwig")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
     */
    @JvmName("rqxwnedcejpwycyn")
    public suspend fun workspaceResourceId(`value`: Output<Any>) {
        this.workspaceResourceId = value
    }

    /**
     * @param value Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression with resultType string).
     */
    @JvmName("mhrigjixrwskndym")
    public suspend
    fun accessToken(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression with resultType string).
     */
    @JvmName("riobuyxasmdloqil")
    public fun accessToken(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression with resultType string).
     */
    @JvmName("egtsxrplxaaafdig")
    public fun accessToken(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("fxrjnuiyldxwrbsy")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("rnskserbbglcyrvm")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Required to specify MSI, if using Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
     */
    @JvmName("nmjilfpfcxkthjjv")
    public suspend fun authentication(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("sgnqggliwgwcbded")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("ibltxckluavkmrik")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("fujpdgrqvgyxjhpp")
    public suspend fun credential(`value`: CredentialReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument The credential reference containing authentication information.
     */
    @JvmName("tnwerbevckrfvwmj")
    public suspend fun credential(argument: suspend CredentialReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("roihhiasftgpdemt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
     */
    @JvmName("ipetygodaudbqfnb")
    public suspend fun domain(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("qnkdoffidkblbxed")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The id of an existing interactive cluster that will be used for all runs of this activity. Type: string (or Expression with resultType string).
     */
    @JvmName("jlkdpxxdmsfxqmci")
    public suspend fun existingClusterId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.existingClusterId = mapped
    }

    /**
     * @param value The id of an existing instance pool that will be used for all runs of this activity. Type: string (or Expression with resultType string).
     */
    @JvmName("ictcuaqqvypifiub")
    public suspend fun instancePoolId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instancePoolId = mapped
    }

    /**
     * @param value Additional tags for cluster resources. This property is ignored in instance pool configurations.
     */
    @JvmName("ffhpingjvtkcnrmr")
    public suspend fun newClusterCustomTags(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newClusterCustomTags = mapped
    }

    /**
     * @param values Additional tags for cluster resources. This property is ignored in instance pool configurations.
     */
    @JvmName("balyovsrjvsgyxbs")
    public fun newClusterCustomTags(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.newClusterCustomTags = mapped
    }

    /**
     * @param value The driver node type for the new job cluster. This property is ignored in instance pool configurations. Type: string (or Expression with resultType string).
     */
    @JvmName("iwprsvfnjyhbusek")
    public suspend fun newClusterDriverNodeType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newClusterDriverNodeType = mapped
    }

    /**
     * @param value Enable the elastic disk on the new cluster. This property is now ignored, and takes the default elastic disk behavior in Databricks (elastic disks are always enabled). Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("uticrdkecnwjkkjn")
    public suspend fun newClusterEnableElasticDisk(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newClusterEnableElasticDisk = mapped
    }

    /**
     * @param value User-defined initialization scripts for the new cluster. Type: array of strings (or Expression with resultType array of strings).
     */
    @JvmName("surbkqfqplqagfqr")
    public suspend fun newClusterInitScripts(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newClusterInitScripts = mapped
    }

    /**
     * @param value Specify a location to deliver Spark driver, worker, and event logs. Type: string (or Expression with resultType string).
     */
    @JvmName("lxcovmuwhjclhxij")
    public suspend fun newClusterLogDestination(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newClusterLogDestination = mapped
    }

    /**
     * @param value The node type of the new job cluster. This property is required if newClusterVersion is specified and instancePoolId is not specified. If instancePoolId is specified, this property is ignored. Type: string (or Expression with resultType string).
     */
    @JvmName("euxqjoesrpekpbak")
    public suspend fun newClusterNodeType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newClusterNodeType = mapped
    }

    /**
     * @param value If not using an existing interactive cluster, this specifies the number of worker nodes to use for the new job cluster or instance pool. For new job clusters, this a string-formatted Int32, like '1' means numOfWorker is 1 or '1:10' means auto-scale from 1 (min) to 10 (max). For instance pools, this is a string-formatted Int32, and can only specify a fixed number of worker nodes, such as '2'. Required if newClusterVersion is specified. Type: string (or Expression with resultType string).
     */
    @JvmName("umddopoynjajtqdf")
    public suspend fun newClusterNumOfWorker(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newClusterNumOfWorker = mapped
    }

    /**
     * @param value A set of optional, user-specified Spark configuration key-value pairs.
     */
    @JvmName("olcpkcpxtrgkotbx")
    public suspend fun newClusterSparkConf(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newClusterSparkConf = mapped
    }

    /**
     * @param values A set of optional, user-specified Spark configuration key-value pairs.
     */
    @JvmName("ygwlpipmtlndugah")
    public fun newClusterSparkConf(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.newClusterSparkConf = mapped
    }

    /**
     * @param value A set of optional, user-specified Spark environment variables key-value pairs.
     */
    @JvmName("uxtogseyhuudkfyt")
    public suspend fun newClusterSparkEnvVars(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newClusterSparkEnvVars = mapped
    }

    /**
     * @param values A set of optional, user-specified Spark environment variables key-value pairs.
     */
    @JvmName("rtvpyvpjdybojqha")
    public fun newClusterSparkEnvVars(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.newClusterSparkEnvVars = mapped
    }

    /**
     * @param value If not using an existing interactive cluster, this specifies the Spark version of a new job cluster or instance pool nodes created for each run of this activity. Required if instancePoolId is specified. Type: string (or Expression with resultType string).
     */
    @JvmName("okvrsnfcftpokwia")
    public suspend fun newClusterVersion(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newClusterVersion = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("jctanmbgcttxpgrp")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("bbccjkssexdpobsn")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("vybtkcusyqjysohk")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The policy id for limiting the ability to configure clusters based on a user defined set of rules. Type: string (or Expression with resultType string).
     */
    @JvmName("wgvpdannkpkmvjmb")
    public suspend fun policyId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureDatabricks'.
     */
    @JvmName("outoixapapxwgxmy")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
     */
    @JvmName("etjekvhaxnprscio")
    public suspend fun workspaceResourceId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceResourceId = mapped
    }

    internal fun build(): AzureDatabricksLinkedServiceArgs = AzureDatabricksLinkedServiceArgs(
        accessToken = accessToken,
        annotations = annotations,
        authentication = authentication,
        connectVia = connectVia,
        credential = credential,
        description = description,
        domain = domain ?: throw PulumiNullFieldException("domain"),
        encryptedCredential = encryptedCredential,
        existingClusterId = existingClusterId,
        instancePoolId = instancePoolId,
        newClusterCustomTags = newClusterCustomTags,
        newClusterDriverNodeType = newClusterDriverNodeType,
        newClusterEnableElasticDisk = newClusterEnableElasticDisk,
        newClusterInitScripts = newClusterInitScripts,
        newClusterLogDestination = newClusterLogDestination,
        newClusterNodeType = newClusterNodeType,
        newClusterNumOfWorker = newClusterNumOfWorker,
        newClusterSparkConf = newClusterSparkConf,
        newClusterSparkEnvVars = newClusterSparkEnvVars,
        newClusterVersion = newClusterVersion,
        parameters = parameters,
        policyId = policyId,
        type = type ?: throw PulumiNullFieldException("type"),
        workspaceResourceId = workspaceResourceId,
    )
}
