@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureFileStorageReadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure File Storage read settings.
 * @property deleteFilesAfterCompletion Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property enablePartitionDiscovery Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
 * @property fileListPath Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property modifiedDatetimeEnd The end of file's modified datetime. Type: string (or Expression with resultType string).
 * @property modifiedDatetimeStart The start of file's modified datetime. Type: string (or Expression with resultType string).
 * @property partitionRootPath Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
 * @property prefix The prefix filter for the Azure File name starting from root path. Type: string (or Expression with resultType string).
 * @property recursive If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
 * @property type The read setting type.
 * Expected value is 'AzureFileStorageReadSettings'.
 * @property wildcardFileName Azure File Storage wildcardFileName. Type: string (or Expression with resultType string).
 * @property wildcardFolderPath Azure File Storage wildcardFolderPath. Type: string (or Expression with resultType string).
 */
public data class AzureFileStorageReadSettingsArgs(
    public val deleteFilesAfterCompletion: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val enablePartitionDiscovery: Output<Any>? = null,
    public val fileListPath: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val modifiedDatetimeEnd: Output<Any>? = null,
    public val modifiedDatetimeStart: Output<Any>? = null,
    public val partitionRootPath: Output<Any>? = null,
    public val prefix: Output<Any>? = null,
    public val recursive: Output<Any>? = null,
    public val type: Output<String>,
    public val wildcardFileName: Output<Any>? = null,
    public val wildcardFolderPath: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureFileStorageReadSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureFileStorageReadSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureFileStorageReadSettingsArgs.builder()
            .deleteFilesAfterCompletion(deleteFilesAfterCompletion?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .enablePartitionDiscovery(enablePartitionDiscovery?.applyValue({ args0 -> args0 }))
            .fileListPath(fileListPath?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .modifiedDatetimeEnd(modifiedDatetimeEnd?.applyValue({ args0 -> args0 }))
            .modifiedDatetimeStart(modifiedDatetimeStart?.applyValue({ args0 -> args0 }))
            .partitionRootPath(partitionRootPath?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .recursive(recursive?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .wildcardFileName(wildcardFileName?.applyValue({ args0 -> args0 }))
            .wildcardFolderPath(wildcardFolderPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFileStorageReadSettingsArgs].
 */
@PulumiTagMarker
public class AzureFileStorageReadSettingsArgsBuilder internal constructor() {
    private var deleteFilesAfterCompletion: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var enablePartitionDiscovery: Output<Any>? = null

    private var fileListPath: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var modifiedDatetimeEnd: Output<Any>? = null

    private var modifiedDatetimeStart: Output<Any>? = null

    private var partitionRootPath: Output<Any>? = null

    private var prefix: Output<Any>? = null

    private var recursive: Output<Any>? = null

    private var type: Output<String>? = null

    private var wildcardFileName: Output<Any>? = null

    private var wildcardFolderPath: Output<Any>? = null

    /**
     * @param value Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("uawnrhpvuumhvptk")
    public suspend fun deleteFilesAfterCompletion(`value`: Output<Any>) {
        this.deleteFilesAfterCompletion = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("chqlkaftonixjnoj")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ovqibcqayxdqgewy")
    public suspend fun enablePartitionDiscovery(`value`: Output<Any>) {
        this.enablePartitionDiscovery = value
    }

    /**
     * @param value Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
     */
    @JvmName("amwxjobjsgbpbklf")
    public suspend fun fileListPath(`value`: Output<Any>) {
        this.fileListPath = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ohfhbfhuwtoddaah")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value The end of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("fiiuoripljgxvqoj")
    public suspend fun modifiedDatetimeEnd(`value`: Output<Any>) {
        this.modifiedDatetimeEnd = value
    }

    /**
     * @param value The start of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("aqxgcbspcniuodet")
    public suspend fun modifiedDatetimeStart(`value`: Output<Any>) {
        this.modifiedDatetimeStart = value
    }

    /**
     * @param value Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
     */
    @JvmName("pvfwokydpaiyodtd")
    public suspend fun partitionRootPath(`value`: Output<Any>) {
        this.partitionRootPath = value
    }

    /**
     * @param value The prefix filter for the Azure File name starting from root path. Type: string (or Expression with resultType string).
     */
    @JvmName("xyfdejjjcaalbhej")
    public suspend fun prefix(`value`: Output<Any>) {
        this.prefix = value
    }

    /**
     * @param value If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("foanaoesjrngqqrt")
    public suspend fun recursive(`value`: Output<Any>) {
        this.recursive = value
    }

    /**
     * @param value The read setting type.
     * Expected value is 'AzureFileStorageReadSettings'.
     */
    @JvmName("ggpaxpqiwniqahbv")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Azure File Storage wildcardFileName. Type: string (or Expression with resultType string).
     */
    @JvmName("eflhfpoixcjeepnl")
    public suspend fun wildcardFileName(`value`: Output<Any>) {
        this.wildcardFileName = value
    }

    /**
     * @param value Azure File Storage wildcardFolderPath. Type: string (or Expression with resultType string).
     */
    @JvmName("hvtdaubetkqtskww")
    public suspend fun wildcardFolderPath(`value`: Output<Any>) {
        this.wildcardFolderPath = value
    }

    /**
     * @param value Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("eyucwmkmvlbyqyip")
    public suspend fun deleteFilesAfterCompletion(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteFilesAfterCompletion = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("quninuqyjdmebugs")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("llnfiawxfifojhbr")
    public suspend fun enablePartitionDiscovery(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePartitionDiscovery = mapped
    }

    /**
     * @param value Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
     */
    @JvmName("sijnsqsipsogswbj")
    public suspend fun fileListPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileListPath = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("fxfktpykgyiweawi")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value The end of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("pmxerosbpdexaqje")
    public suspend fun modifiedDatetimeEnd(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedDatetimeEnd = mapped
    }

    /**
     * @param value The start of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("hyhcqeppwdmhdehj")
    public suspend fun modifiedDatetimeStart(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedDatetimeStart = mapped
    }

    /**
     * @param value Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
     */
    @JvmName("dxtutehghuvkdcpj")
    public suspend fun partitionRootPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionRootPath = mapped
    }

    /**
     * @param value The prefix filter for the Azure File name starting from root path. Type: string (or Expression with resultType string).
     */
    @JvmName("rkklexksecuosgqa")
    public suspend fun prefix(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("dolsonsqjbtewxqv")
    public suspend fun recursive(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recursive = mapped
    }

    /**
     * @param value The read setting type.
     * Expected value is 'AzureFileStorageReadSettings'.
     */
    @JvmName("bvmpxbkesyqbrjyi")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Azure File Storage wildcardFileName. Type: string (or Expression with resultType string).
     */
    @JvmName("atyjmdcgjpcqnchf")
    public suspend fun wildcardFileName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wildcardFileName = mapped
    }

    /**
     * @param value Azure File Storage wildcardFolderPath. Type: string (or Expression with resultType string).
     */
    @JvmName("ffrdlxluhsanjvxl")
    public suspend fun wildcardFolderPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wildcardFolderPath = mapped
    }

    internal fun build(): AzureFileStorageReadSettingsArgs = AzureFileStorageReadSettingsArgs(
        deleteFilesAfterCompletion = deleteFilesAfterCompletion,
        disableMetricsCollection = disableMetricsCollection,
        enablePartitionDiscovery = enablePartitionDiscovery,
        fileListPath = fileListPath,
        maxConcurrentConnections = maxConcurrentConnections,
        modifiedDatetimeEnd = modifiedDatetimeEnd,
        modifiedDatetimeStart = modifiedDatetimeStart,
        partitionRootPath = partitionRootPath,
        prefix = prefix,
        recursive = recursive,
        type = type ?: throw PulumiNullFieldException("type"),
        wildcardFileName = wildcardFileName,
        wildcardFolderPath = wildcardFolderPath,
    )
}
