@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureFunctionLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure Function linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authentication Type of authentication (Required to specify MSI) used to connect to AzureFunction. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property credential The credential reference containing authentication information.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property functionAppUrl The endpoint of the Azure Function App. URL will be in the format https://<accountName>.azurewebsites.net. Type: string (or Expression with resultType string).
 * @property functionKey Function or Host key for Azure Function App.
 * @property parameters Parameters for linked service.
 * @property resourceId Allowed token audiences for azure function. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'AzureFunction'.
 */
public data class AzureFunctionLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val authentication: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val credential: Output<CredentialReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val functionAppUrl: Output<Any>,
    public val functionKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val resourceId: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureFunctionLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureFunctionLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureFunctionLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authentication(authentication?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .functionAppUrl(functionAppUrl.applyValue({ args0 -> args0 }))
            .functionKey(
                functionKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFunctionLinkedServiceArgs].
 */
@PulumiTagMarker
public class AzureFunctionLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var authentication: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var credential: Output<CredentialReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var functionAppUrl: Output<Any>? = null

    private var functionKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var resourceId: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("brbcwynwyaiqrqhn")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("mogdigcingpvuljd")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("nrdfttvbdfmugeks")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Type of authentication (Required to specify MSI) used to connect to AzureFunction. Type: string (or Expression with resultType string).
     */
    @JvmName("qdjmocwrnlkgxmgg")
    public suspend fun authentication(`value`: Output<Any>) {
        this.authentication = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("bgmbxtcjhvmqcobi")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("jhtjfebudijiehao")
    public suspend fun credential(`value`: Output<CredentialReferenceArgs>) {
        this.credential = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("xyfblpnxjrvtwtfv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("imrrebunnfwkvgil")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The endpoint of the Azure Function App. URL will be in the format https://<accountName>.azurewebsites.net. Type: string (or Expression with resultType string).
     */
    @JvmName("btclrxlexvbfqpni")
    public suspend fun functionAppUrl(`value`: Output<Any>) {
        this.functionAppUrl = value
    }

    /**
     * @param value Function or Host key for Azure Function App.
     */
    @JvmName("kmbafxktesojkvho")
    public suspend
    fun functionKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.functionKey = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("giajuqdlolvlmgsf")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Allowed token audiences for azure function. Type: string (or Expression with resultType string).
     */
    @JvmName("gxxoihjsvccrekep")
    public suspend fun resourceId(`value`: Output<Any>) {
        this.resourceId = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureFunction'.
     */
    @JvmName("osgcdygrygwllhbu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("tplmsswreyoejqah")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("xruvksvdpwoaxdbj")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Type of authentication (Required to specify MSI) used to connect to AzureFunction. Type: string (or Expression with resultType string).
     */
    @JvmName("iapelrutfdljwpqv")
    public suspend fun authentication(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("sjmlyaivtuveqatc")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("txcvjhusuhdaueee")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("nfsbkkcfoocxlijs")
    public suspend fun credential(`value`: CredentialReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument The credential reference containing authentication information.
     */
    @JvmName("rwdvtxfgevabwgig")
    public suspend fun credential(argument: suspend CredentialReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("oudqosxmjyretapn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("nnkvmqgsufffkshl")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The endpoint of the Azure Function App. URL will be in the format https://<accountName>.azurewebsites.net. Type: string (or Expression with resultType string).
     */
    @JvmName("vpjavapiiujehmeg")
    public suspend fun functionAppUrl(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionAppUrl = mapped
    }

    /**
     * @param value Function or Host key for Azure Function App.
     */
    @JvmName("gcdncoldquehljdq")
    public suspend
    fun functionKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionKey = mapped
    }

    /**
     * @param value Function or Host key for Azure Function App.
     */
    @JvmName("noclecljiwlrnkax")
    public fun functionKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionKey = mapped
    }

    /**
     * @param value Function or Host key for Azure Function App.
     */
    @JvmName("ockdtjhufdsgtoit")
    public fun functionKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionKey = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("cutmdsmfjrehgqso")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("ovdmsdshlamnndbr")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("jprjmrsvicgdovpr")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Allowed token audiences for azure function. Type: string (or Expression with resultType string).
     */
    @JvmName("kgipdsjhabxfrjjr")
    public suspend fun resourceId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureFunction'.
     */
    @JvmName("nmyxehwehhpkkrnp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureFunctionLinkedServiceArgs = AzureFunctionLinkedServiceArgs(
        annotations = annotations,
        authentication = authentication,
        connectVia = connectVia,
        credential = credential,
        description = description,
        encryptedCredential = encryptedCredential,
        functionAppUrl = functionAppUrl ?: throw PulumiNullFieldException("functionAppUrl"),
        functionKey = functionKey,
        parameters = parameters,
        resourceId = resourceId,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
