@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureMLWebServiceFileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure ML WebService Input/Output file
 * @property filePath The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type: string (or Expression with resultType string).
 * @property linkedServiceName Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located.
 */
public data class AzureMLWebServiceFileArgs(
    public val filePath: Output<Any>,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureMLWebServiceFileArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureMLWebServiceFileArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureMLWebServiceFileArgs.builder()
            .filePath(filePath.applyValue({ args0 -> args0 }))
            .linkedServiceName(
                linkedServiceName.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureMLWebServiceFileArgs].
 */
@PulumiTagMarker
public class AzureMLWebServiceFileArgsBuilder internal constructor() {
    private var filePath: Output<Any>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    /**
     * @param value The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type: string (or Expression with resultType string).
     */
    @JvmName("wjyjowvpfmvisusm")
    public suspend fun filePath(`value`: Output<Any>) {
        this.filePath = value
    }

    /**
     * @param value Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located.
     */
    @JvmName("mxksqdvombxcmmxo")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type: string (or Expression with resultType string).
     */
    @JvmName("bynigljbmadcnvxp")
    public suspend fun filePath(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filePath = mapped
    }

    /**
     * @param value Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located.
     */
    @JvmName("livvdycxcjeuxlcq")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located.
     */
    @JvmName("ooafmqrfrvdkehrc")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    internal fun build(): AzureMLWebServiceFileArgs = AzureMLWebServiceFileArgs(
        filePath = filePath ?: throw PulumiNullFieldException("filePath"),
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
    )
}
