@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureStorageLinkedServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The storage account linked service.
 * @property accountKey The Azure key vault secret reference of accountKey in connection string.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property connectionString The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property sasToken The Azure key vault secret reference of sasToken in sas uri.
 * @property sasUri SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property type Type of linked service.
 * Expected value is 'AzureStorage'.
 */
public data class AzureStorageLinkedServiceArgs(
    public val accountKey: Output<AzureKeyVaultSecretReferenceArgs>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionString: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val sasToken: Output<AzureKeyVaultSecretReferenceArgs>? = null,
    public val sasUri: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureStorageLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureStorageLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureStorageLinkedServiceArgs.builder()
            .accountKey(accountKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .sasToken(sasToken?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sasUri(sasUri?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureStorageLinkedServiceArgs].
 */
@PulumiTagMarker
public class AzureStorageLinkedServiceArgsBuilder internal constructor() {
    private var accountKey: Output<AzureKeyVaultSecretReferenceArgs>? = null

    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionString: Output<Any>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var sasToken: Output<AzureKeyVaultSecretReferenceArgs>? = null

    private var sasUri: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value The Azure key vault secret reference of accountKey in connection string.
     */
    @JvmName("deflkifdpfcvblai")
    public suspend fun accountKey(`value`: Output<AzureKeyVaultSecretReferenceArgs>) {
        this.accountKey = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("lxkvrpebiwpxyuiy")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("jhxqpejvemuinrek")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("vtquebebyyxrlorr")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("uucvujifkoebwnab")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("prxeoryfiijvsqwq")
    public suspend fun connectionString(`value`: Output<Any>) {
        this.connectionString = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("osvwkjenllhxlogr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("qpmqhrwsxplitacw")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("vqvwxbafxbxfwrfy")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The Azure key vault secret reference of sasToken in sas uri.
     */
    @JvmName("yliojkwnmypdqwii")
    public suspend fun sasToken(`value`: Output<AzureKeyVaultSecretReferenceArgs>) {
        this.sasToken = value
    }

    /**
     * @param value SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("tgpehlqnbjgmhtpi")
    public suspend fun sasUri(`value`: Output<Any>) {
        this.sasUri = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureStorage'.
     */
    @JvmName("oiqxcjhsceklicvm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The Azure key vault secret reference of accountKey in connection string.
     */
    @JvmName("aukmvdsmfmkjavce")
    public suspend fun accountKey(`value`: AzureKeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param argument The Azure key vault secret reference of accountKey in connection string.
     */
    @JvmName("ejbeltjlummjgvxx")
    public suspend
    fun accountKey(argument: suspend AzureKeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = AzureKeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accountKey = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("givjlunaodqdjlmc")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("xhhypanwgqwnykqu")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("suupcbfhaovnjhgj")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("ecwkvepnnclbtmvj")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("buibgmtgflidxyhk")
    public suspend fun connectionString(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("xgxnxfowiuaqirbd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("lbjflyfhufcybxqr")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("skcrjjfqrfjserxu")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("ivuxblixqiqeqirn")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("kqjnkfiouvgbwsvy")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The Azure key vault secret reference of sasToken in sas uri.
     */
    @JvmName("nnvyiuhirbifjgdl")
    public suspend fun sasToken(`value`: AzureKeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasToken = mapped
    }

    /**
     * @param argument The Azure key vault secret reference of sasToken in sas uri.
     */
    @JvmName("gbnojjgtutngajmj")
    public suspend
    fun sasToken(argument: suspend AzureKeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = AzureKeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sasToken = mapped
    }

    /**
     * @param value SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("qgibkxestylwipde")
    public suspend fun sasUri(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasUri = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureStorage'.
     */
    @JvmName("ottgraetaupobyaa")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureStorageLinkedServiceArgs = AzureStorageLinkedServiceArgs(
        accountKey = accountKey,
        annotations = annotations,
        connectVia = connectVia,
        connectionString = connectionString,
        description = description,
        encryptedCredential = encryptedCredential,
        parameters = parameters,
        sasToken = sasToken,
        sasUri = sasUri,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
