@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureSynapseArtifactsLinkedServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure Synapse Analytics (Artifacts) linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authentication Required to specify MSI, if using system assigned managed identity as authentication method. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property endpoint https://<workspacename>.dev.azuresynapse.net, Azure Synapse Analytics workspace URL. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property type Type of linked service.
 * Expected value is 'AzureSynapseArtifacts'.
 * @property workspaceResourceId The resource ID of the Synapse workspace. The format should be: /subscriptions/{subscriptionID}/resourceGroups/{resourceGroup}/providers/Microsoft.Synapse/workspaces/{workspaceName}. Type: string (or Expression with resultType string).
 */
public data class AzureSynapseArtifactsLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val authentication: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val endpoint: Output<Any>,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val type: Output<String>,
    public val workspaceResourceId: Output<Any>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureSynapseArtifactsLinkedServiceArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.AzureSynapseArtifactsLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureSynapseArtifactsLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authentication(authentication?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .workspaceResourceId(workspaceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureSynapseArtifactsLinkedServiceArgs].
 */
@PulumiTagMarker
public class AzureSynapseArtifactsLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var authentication: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var endpoint: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var type: Output<String>? = null

    private var workspaceResourceId: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("piunqqtbcmihlmca")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("ohvteslrvywyufuw")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("wmehokqufcieuguw")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Required to specify MSI, if using system assigned managed identity as authentication method. Type: string (or Expression with resultType string).
     */
    @JvmName("lgkggyigkoqmxmoh")
    public suspend fun authentication(`value`: Output<Any>) {
        this.authentication = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("glhuaooikjogffdi")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("rhcltgnkorhlqupc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value https://<workspacename>.dev.azuresynapse.net, Azure Synapse Analytics workspace URL. Type: string (or Expression with resultType string).
     */
    @JvmName("whxfcfymkwclugcw")
    public suspend fun endpoint(`value`: Output<Any>) {
        this.endpoint = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("uywbyktpwbiphoqo")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureSynapseArtifacts'.
     */
    @JvmName("hjciojrkpciaqqbn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The resource ID of the Synapse workspace. The format should be: /subscriptions/{subscriptionID}/resourceGroups/{resourceGroup}/providers/Microsoft.Synapse/workspaces/{workspaceName}. Type: string (or Expression with resultType string).
     */
    @JvmName("mankvtxnfbwqdsbv")
    public suspend fun workspaceResourceId(`value`: Output<Any>) {
        this.workspaceResourceId = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("ocfswhdydcjerovo")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("ekluvkqxjxcinuve")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Required to specify MSI, if using system assigned managed identity as authentication method. Type: string (or Expression with resultType string).
     */
    @JvmName("onwkvvkkxxrdlyvh")
    public suspend fun authentication(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("rqoataefpjfnujnu")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("wksdcxljgkccwfll")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("rlbukclvmxwdffge")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value https://<workspacename>.dev.azuresynapse.net, Azure Synapse Analytics workspace URL. Type: string (or Expression with resultType string).
     */
    @JvmName("yplfnmtgfbkdriej")
    public suspend fun endpoint(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("tbnooxoqvglvycjy")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("dcnbadyvhirbulmj")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("fxwcbpiindufsmsx")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureSynapseArtifacts'.
     */
    @JvmName("pdxclijbcqlxhswm")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The resource ID of the Synapse workspace. The format should be: /subscriptions/{subscriptionID}/resourceGroups/{resourceGroup}/providers/Microsoft.Synapse/workspaces/{workspaceName}. Type: string (or Expression with resultType string).
     */
    @JvmName("hwcjprbvbpatebof")
    public suspend fun workspaceResourceId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceResourceId = mapped
    }

    internal fun build(): AzureSynapseArtifactsLinkedServiceArgs =
        AzureSynapseArtifactsLinkedServiceArgs(
            annotations = annotations,
            authentication = authentication,
            connectVia = connectVia,
            description = description,
            endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
            parameters = parameters,
            type = type ?: throw PulumiNullFieldException("type"),
            workspaceResourceId = workspaceResourceId,
        )
}
