@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.BlobEventsTriggerArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.BlobEventTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Trigger that runs every time a Blob event occurs.
 * @property annotations List of tags that can be used for describing the trigger.
 * @property blobPathBeginsWith The blob path must begin with the pattern provided for trigger to fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the december folder under the records container. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
 * @property blobPathEndsWith The blob path must end with the pattern provided for trigger to fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
 * @property description Trigger description.
 * @property events The type of events that cause this trigger to fire.
 * @property ignoreEmptyBlobs If set to true, blobs with zero bytes will be ignored.
 * @property pipelines Pipelines that need to be started.
 * @property scope The ARM resource ID of the Storage Account.
 * @property type Trigger type.
 * Expected value is 'BlobEventsTrigger'.
 */
public data class BlobEventsTriggerArgs(
    public val annotations: Output<List<Any>>? = null,
    public val blobPathBeginsWith: Output<String>? = null,
    public val blobPathEndsWith: Output<String>? = null,
    public val description: Output<String>? = null,
    public val events: Output<List<Either<String, BlobEventTypes>>>,
    public val ignoreEmptyBlobs: Output<Boolean>? = null,
    public val pipelines: Output<List<TriggerPipelineReferenceArgs>>? = null,
    public val scope: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.BlobEventsTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.BlobEventsTriggerArgs =
        com.pulumi.azurenative.datafactory.inputs.BlobEventsTriggerArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .blobPathBeginsWith(blobPathBeginsWith?.applyValue({ args0 -> args0 }))
            .blobPathEndsWith(blobPathEndsWith?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .events(
                events.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .ignoreEmptyBlobs(ignoreEmptyBlobs?.applyValue({ args0 -> args0 }))
            .pipelines(
                pipelines?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scope(scope.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobEventsTriggerArgs].
 */
@PulumiTagMarker
public class BlobEventsTriggerArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var blobPathBeginsWith: Output<String>? = null

    private var blobPathEndsWith: Output<String>? = null

    private var description: Output<String>? = null

    private var events: Output<List<Either<String, BlobEventTypes>>>? = null

    private var ignoreEmptyBlobs: Output<Boolean>? = null

    private var pipelines: Output<List<TriggerPipelineReferenceArgs>>? = null

    private var scope: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("gjocalnhvercbeng")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("whrletxjyxctkbci")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("fegseqqdbxqmejaj")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The blob path must begin with the pattern provided for trigger to fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the december folder under the records container. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
     */
    @JvmName("alhibxfkiyuwpxuj")
    public suspend fun blobPathBeginsWith(`value`: Output<String>) {
        this.blobPathBeginsWith = value
    }

    /**
     * @param value The blob path must end with the pattern provided for trigger to fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
     */
    @JvmName("nwdqaltlcufysuqh")
    public suspend fun blobPathEndsWith(`value`: Output<String>) {
        this.blobPathEndsWith = value
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("etduroavvacjggif")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The type of events that cause this trigger to fire.
     */
    @JvmName("mdmuxmwxngwvqhwf")
    public suspend fun events(`value`: Output<List<Either<String, BlobEventTypes>>>) {
        this.events = value
    }

    @JvmName("ftdqppghfvxpvatt")
    public suspend fun events(vararg values: Output<Either<String, BlobEventTypes>>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values The type of events that cause this trigger to fire.
     */
    @JvmName("dwmrjmpogjtanclq")
    public suspend fun events(values: List<Output<Either<String, BlobEventTypes>>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value If set to true, blobs with zero bytes will be ignored.
     */
    @JvmName("yyjgbnispkujblmo")
    public suspend fun ignoreEmptyBlobs(`value`: Output<Boolean>) {
        this.ignoreEmptyBlobs = value
    }

    /**
     * @param value Pipelines that need to be started.
     */
    @JvmName("futjhcovijsbhjvu")
    public suspend fun pipelines(`value`: Output<List<TriggerPipelineReferenceArgs>>) {
        this.pipelines = value
    }

    @JvmName("uwblcgarwbdimkah")
    public suspend fun pipelines(vararg values: Output<TriggerPipelineReferenceArgs>) {
        this.pipelines = Output.all(values.asList())
    }

    /**
     * @param values Pipelines that need to be started.
     */
    @JvmName("gelurkmnhxhhxsby")
    public suspend fun pipelines(values: List<Output<TriggerPipelineReferenceArgs>>) {
        this.pipelines = Output.all(values)
    }

    /**
     * @param value The ARM resource ID of the Storage Account.
     */
    @JvmName("uqimcsnkcwfsvwaj")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Trigger type.
     * Expected value is 'BlobEventsTrigger'.
     */
    @JvmName("kbmfluhxmounwkvj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("tqcpupfdaevnmuny")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("otrommmxnhxsdnwy")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The blob path must begin with the pattern provided for trigger to fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the december folder under the records container. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
     */
    @JvmName("gyirtjfutkodqyqt")
    public suspend fun blobPathBeginsWith(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobPathBeginsWith = mapped
    }

    /**
     * @param value The blob path must end with the pattern provided for trigger to fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
     */
    @JvmName("iyppblkwxbbokcei")
    public suspend fun blobPathEndsWith(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobPathEndsWith = mapped
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("jcdmrlfqttyoudht")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The type of events that cause this trigger to fire.
     */
    @JvmName("nplxlpnwksavglbm")
    public suspend fun events(`value`: List<Either<String, BlobEventTypes>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param values The type of events that cause this trigger to fire.
     */
    @JvmName("nofcmptwcdkpycak")
    public suspend fun events(vararg values: Either<String, BlobEventTypes>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param value If set to true, blobs with zero bytes will be ignored.
     */
    @JvmName("usafmjnafrjkfgxx")
    public suspend fun ignoreEmptyBlobs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreEmptyBlobs = mapped
    }

    /**
     * @param value Pipelines that need to be started.
     */
    @JvmName("moxxecbnimuwwlsu")
    public suspend fun pipelines(`value`: List<TriggerPipelineReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines that need to be started.
     */
    @JvmName("yckncgwhheuybgge")
    public suspend
    fun pipelines(argument: List<suspend TriggerPipelineReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TriggerPipelineReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines that need to be started.
     */
    @JvmName("ontqfdtemstdluqb")
    public suspend fun pipelines(
        vararg
        argument: suspend TriggerPipelineReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TriggerPipelineReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines that need to be started.
     */
    @JvmName("ebcmmpwbftcqemwv")
    public suspend fun pipelines(argument: suspend TriggerPipelineReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TriggerPipelineReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param values Pipelines that need to be started.
     */
    @JvmName("fmpkyapbltaegmnk")
    public suspend fun pipelines(vararg values: TriggerPipelineReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pipelines = mapped
    }

    /**
     * @param value The ARM resource ID of the Storage Account.
     */
    @JvmName("cetjvkgltudrojbx")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Trigger type.
     * Expected value is 'BlobEventsTrigger'.
     */
    @JvmName("mdtmlwqhlvjcljwy")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): BlobEventsTriggerArgs = BlobEventsTriggerArgs(
        annotations = annotations,
        blobPathBeginsWith = blobPathBeginsWith,
        blobPathEndsWith = blobPathEndsWith,
        description = description,
        events = events ?: throw PulumiNullFieldException("events"),
        ignoreEmptyBlobs = ignoreEmptyBlobs,
        pipelines = pipelines,
        scope = scope ?: throw PulumiNullFieldException("scope"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
