@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.CMKIdentityDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed Identity used for CMK.
 * @property userAssignedIdentity The resource id of the user assigned identity to authenticate to customer's key vault.
 */
public data class CMKIdentityDefinitionArgs(
    public val userAssignedIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.CMKIdentityDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.CMKIdentityDefinitionArgs =
        com.pulumi.azurenative.datafactory.inputs.CMKIdentityDefinitionArgs.builder()
            .userAssignedIdentity(userAssignedIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CMKIdentityDefinitionArgs].
 */
@PulumiTagMarker
public class CMKIdentityDefinitionArgsBuilder internal constructor() {
    private var userAssignedIdentity: Output<String>? = null

    /**
     * @param value The resource id of the user assigned identity to authenticate to customer's key vault.
     */
    @JvmName("obdofsgcbvdxlljd")
    public suspend fun userAssignedIdentity(`value`: Output<String>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value The resource id of the user assigned identity to authenticate to customer's key vault.
     */
    @JvmName("kwgsgsahygylhhkq")
    public suspend fun userAssignedIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): CMKIdentityDefinitionArgs = CMKIdentityDefinitionArgs(
        userAssignedIdentity = userAssignedIdentity,
    )
}
