@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.CredentialReferenceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.CredentialReferenceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Credential reference type.
 * @property referenceName Reference credential name.
 * @property type Credential reference type.
 */
public data class CredentialReferenceArgs(
    public val referenceName: Output<String>,
    public val type: Output<Either<String, CredentialReferenceType>>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.CredentialReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.CredentialReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.CredentialReferenceArgs.builder()
            .referenceName(referenceName.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CredentialReferenceArgs].
 */
@PulumiTagMarker
public class CredentialReferenceArgsBuilder internal constructor() {
    private var referenceName: Output<String>? = null

    private var type: Output<Either<String, CredentialReferenceType>>? = null

    /**
     * @param value Reference credential name.
     */
    @JvmName("jfqyvtcafvfmwfor")
    public suspend fun referenceName(`value`: Output<String>) {
        this.referenceName = value
    }

    /**
     * @param value Credential reference type.
     */
    @JvmName("mhnivigbuhvejrev")
    public suspend fun type(`value`: Output<Either<String, CredentialReferenceType>>) {
        this.type = value
    }

    /**
     * @param value Reference credential name.
     */
    @JvmName("frehtihhdpovhqmu")
    public suspend fun referenceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    /**
     * @param value Credential reference type.
     */
    @JvmName("tugquahunxspmkdv")
    public suspend fun type(`value`: Either<String, CredentialReferenceType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Credential reference type.
     */
    @JvmName("qxbrfefakgvwlfpf")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CredentialReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Credential reference type.
     */
    @JvmName("rvxwlbwrvrexsasu")
    public fun type(`value`: CredentialReferenceType) {
        val toBeMapped = Either.ofRight<String, CredentialReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): CredentialReferenceArgs = CredentialReferenceArgs(
        referenceName = referenceName ?: throw PulumiNullFieldException("referenceName"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
