@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DocumentDbCollectionSinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A copy activity Document Database Collection sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property nestingSeparator Nested properties separator. Default is . (dot). Type: string (or Expression with resultType string).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy sink type.
 * Expected value is 'DocumentDbCollectionSink'.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property writeBehavior Describes how to write data to Azure Cosmos DB. Type: string (or Expression with resultType string). Allowed values: insert and upsert.
 */
public data class DocumentDbCollectionSinkArgs(
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val nestingSeparator: Output<Any>? = null,
    public val sinkRetryCount: Output<Any>? = null,
    public val sinkRetryWait: Output<Any>? = null,
    public val type: Output<String>,
    public val writeBatchSize: Output<Any>? = null,
    public val writeBatchTimeout: Output<Any>? = null,
    public val writeBehavior: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DocumentDbCollectionSinkArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DocumentDbCollectionSinkArgs =
        com.pulumi.azurenative.datafactory.inputs.DocumentDbCollectionSinkArgs.builder()
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .nestingSeparator(nestingSeparator?.applyValue({ args0 -> args0 }))
            .sinkRetryCount(sinkRetryCount?.applyValue({ args0 -> args0 }))
            .sinkRetryWait(sinkRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .writeBatchSize(writeBatchSize?.applyValue({ args0 -> args0 }))
            .writeBatchTimeout(writeBatchTimeout?.applyValue({ args0 -> args0 }))
            .writeBehavior(writeBehavior?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DocumentDbCollectionSinkArgs].
 */
@PulumiTagMarker
public class DocumentDbCollectionSinkArgsBuilder internal constructor() {
    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var nestingSeparator: Output<Any>? = null

    private var sinkRetryCount: Output<Any>? = null

    private var sinkRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    private var writeBatchSize: Output<Any>? = null

    private var writeBatchTimeout: Output<Any>? = null

    private var writeBehavior: Output<Any>? = null

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("npmimucnqwyuclnc")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ecbblmdobejsfcra")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Nested properties separator. Default is . (dot). Type: string (or Expression with resultType string).
     */
    @JvmName("nbsshmyenbyrccwv")
    public suspend fun nestingSeparator(`value`: Output<Any>) {
        this.nestingSeparator = value
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("mnqlviurkhpgqeje")
    public suspend fun sinkRetryCount(`value`: Output<Any>) {
        this.sinkRetryCount = value
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("pmvhijxqwyghjqfi")
    public suspend fun sinkRetryWait(`value`: Output<Any>) {
        this.sinkRetryWait = value
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'DocumentDbCollectionSink'.
     */
    @JvmName("rugkjsbfmlycnige")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("uwohphupjuslnxwp")
    public suspend fun writeBatchSize(`value`: Output<Any>) {
        this.writeBatchSize = value
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("bvkpmtctnlxxkspa")
    public suspend fun writeBatchTimeout(`value`: Output<Any>) {
        this.writeBatchTimeout = value
    }

    /**
     * @param value Describes how to write data to Azure Cosmos DB. Type: string (or Expression with resultType string). Allowed values: insert and upsert.
     */
    @JvmName("maleoybxmlppacus")
    public suspend fun writeBehavior(`value`: Output<Any>) {
        this.writeBehavior = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("iegbryfducnyfuaa")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("glxptsbtqiidodrh")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Nested properties separator. Default is . (dot). Type: string (or Expression with resultType string).
     */
    @JvmName("jbypmrlcawvoufnl")
    public suspend fun nestingSeparator(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nestingSeparator = mapped
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("yhpivblecndfikbx")
    public suspend fun sinkRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryCount = mapped
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("nxcnruvbggjywtrn")
    public suspend fun sinkRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryWait = mapped
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'DocumentDbCollectionSink'.
     */
    @JvmName("xceapikctmyiiwik")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("yivnyxslriikstgw")
    public suspend fun writeBatchSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchSize = mapped
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("yufajumuimgpughb")
    public suspend fun writeBatchTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchTimeout = mapped
    }

    /**
     * @param value Describes how to write data to Azure Cosmos DB. Type: string (or Expression with resultType string). Allowed values: insert and upsert.
     */
    @JvmName("jitjrjvdxjngitje")
    public suspend fun writeBehavior(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBehavior = mapped
    }

    internal fun build(): DocumentDbCollectionSinkArgs = DocumentDbCollectionSinkArgs(
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        nestingSeparator = nestingSeparator,
        sinkRetryCount = sinkRetryCount,
        sinkRetryWait = sinkRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
        writeBatchSize = writeBatchSize,
        writeBatchTimeout = writeBatchTimeout,
        writeBehavior = writeBehavior,
    )
}
