@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DynamicsLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Dynamics linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The authentication type to connect to Dynamics server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario, 'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property credential The credential reference containing authentication information.
 * @property deploymentType The deployment type of the Dynamics instance. 'Online' for Dynamics Online and 'OnPremisesWithIfd' for Dynamics on-premises with Ifd. Type: string (or Expression with resultType string).
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property hostName The host name of the on-premises Dynamics server. The property is required for on-prem and not allowed for online. Type: string (or Expression with resultType string).
 * @property organizationName The organization name of the Dynamics instance. The property is required for on-prem and required for online when there are more than one Dynamics instances associated with the user. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property password Password to access the Dynamics instance.
 * @property port The port of on-premises Dynamics server. The property is required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property servicePrincipalCredential The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
 * @property servicePrincipalCredentialType The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string).
 * @property servicePrincipalId The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression with resultType string).
 * @property serviceUri The URL to the Microsoft Dynamics server. The property is required for on-line and not allowed for on-prem. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'Dynamics'.
 * @property username User name to access the Dynamics instance. Type: string (or Expression with resultType string).
 */
public data class DynamicsLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val authenticationType: Output<Any>,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val credential: Output<CredentialReferenceArgs>? = null,
    public val deploymentType: Output<Any>,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val hostName: Output<Any>? = null,
    public val organizationName: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val port: Output<Any>? = null,
    public val servicePrincipalCredential:
    Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val servicePrincipalCredentialType: Output<Any>? = null,
    public val servicePrincipalId: Output<Any>? = null,
    public val serviceUri: Output<Any>? = null,
    public val type: Output<String>,
    public val username: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DynamicsLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DynamicsLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.DynamicsLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(authenticationType.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deploymentType(deploymentType.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .organizationName(organizationName?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .port(port?.applyValue({ args0 -> args0 }))
            .servicePrincipalCredential(
                servicePrincipalCredential?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .servicePrincipalCredentialType(servicePrincipalCredentialType?.applyValue({ args0 -> args0 }))
            .servicePrincipalId(servicePrincipalId?.applyValue({ args0 -> args0 }))
            .serviceUri(serviceUri?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DynamicsLinkedServiceArgs].
 */
@PulumiTagMarker
public class DynamicsLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var authenticationType: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var credential: Output<CredentialReferenceArgs>? = null

    private var deploymentType: Output<Any>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var hostName: Output<Any>? = null

    private var organizationName: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var port: Output<Any>? = null

    private var servicePrincipalCredential:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var servicePrincipalCredentialType: Output<Any>? = null

    private var servicePrincipalId: Output<Any>? = null

    private var serviceUri: Output<Any>? = null

    private var type: Output<String>? = null

    private var username: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("vumwgcbgsiqkhbum")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("hfkjgvkrpyraysgu")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("xvkyxfubivmhusxg")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The authentication type to connect to Dynamics server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario, 'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or Expression with resultType string).
     */
    @JvmName("huggtsbddstwctmf")
    public suspend fun authenticationType(`value`: Output<Any>) {
        this.authenticationType = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("kkltqpqigelvkixp")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("ddtlqdkwjvwfmnph")
    public suspend fun credential(`value`: Output<CredentialReferenceArgs>) {
        this.credential = value
    }

    /**
     * @param value The deployment type of the Dynamics instance. 'Online' for Dynamics Online and 'OnPremisesWithIfd' for Dynamics on-premises with Ifd. Type: string (or Expression with resultType string).
     */
    @JvmName("erqypbqsntvbrbhw")
    public suspend fun deploymentType(`value`: Output<Any>) {
        this.deploymentType = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("cijudxglfuuetwlp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("fubojjdacnydtlkh")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The host name of the on-premises Dynamics server. The property is required for on-prem and not allowed for online. Type: string (or Expression with resultType string).
     */
    @JvmName("lmxvwgkkfnufvxak")
    public suspend fun hostName(`value`: Output<Any>) {
        this.hostName = value
    }

    /**
     * @param value The organization name of the Dynamics instance. The property is required for on-prem and required for online when there are more than one Dynamics instances associated with the user. Type: string (or Expression with resultType string).
     */
    @JvmName("xbfjgvkkonframeq")
    public suspend fun organizationName(`value`: Output<Any>) {
        this.organizationName = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("tpynuwytcaixfkae")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Password to access the Dynamics instance.
     */
    @JvmName("rlliyoksawsvmlww")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value The port of on-premises Dynamics server. The property is required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("ngpqvysvtqjihiei")
    public suspend fun port(`value`: Output<Any>) {
        this.port = value
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("hnupffbqosvkobsf")
    public suspend
    fun servicePrincipalCredential(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalCredential = value
    }

    /**
     * @param value The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string).
     */
    @JvmName("hthsrhqdxtexjcca")
    public suspend fun servicePrincipalCredentialType(`value`: Output<Any>) {
        this.servicePrincipalCredentialType = value
    }

    /**
     * @param value The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("gcxpwhkodiejldgr")
    public suspend fun servicePrincipalId(`value`: Output<Any>) {
        this.servicePrincipalId = value
    }

    /**
     * @param value The URL to the Microsoft Dynamics server. The property is required for on-line and not allowed for on-prem. Type: string (or Expression with resultType string).
     */
    @JvmName("snnepptcqvtklfmj")
    public suspend fun serviceUri(`value`: Output<Any>) {
        this.serviceUri = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Dynamics'.
     */
    @JvmName("faguntwsqraohbxq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value User name to access the Dynamics instance. Type: string (or Expression with resultType string).
     */
    @JvmName("lonrdlbafpdwersn")
    public suspend fun username(`value`: Output<Any>) {
        this.username = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("npwbarrewrwejcis")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("okeiujpjfwcmmhou")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The authentication type to connect to Dynamics server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario, 'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or Expression with resultType string).
     */
    @JvmName("mqbambvxigqoolsv")
    public suspend fun authenticationType(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("tkamwgwnnvyycpcl")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("bdqiflsajrdrxxbc")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("ysveothvqdrdvajd")
    public suspend fun credential(`value`: CredentialReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument The credential reference containing authentication information.
     */
    @JvmName("cgavqsixcjpcotwi")
    public suspend fun credential(argument: suspend CredentialReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value The deployment type of the Dynamics instance. 'Online' for Dynamics Online and 'OnPremisesWithIfd' for Dynamics on-premises with Ifd. Type: string (or Expression with resultType string).
     */
    @JvmName("ctmlaxglnealcemh")
    public suspend fun deploymentType(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentType = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("esdxseflvbxcvxwa")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("vghgcmgabbuairje")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The host name of the on-premises Dynamics server. The property is required for on-prem and not allowed for online. Type: string (or Expression with resultType string).
     */
    @JvmName("rntxnmvyotjvptho")
    public suspend fun hostName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value The organization name of the Dynamics instance. The property is required for on-prem and required for online when there are more than one Dynamics instances associated with the user. Type: string (or Expression with resultType string).
     */
    @JvmName("rfgeaaeihmydkirp")
    public suspend fun organizationName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationName = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("lydudvajrpxygfav")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("vsocskttxkildttd")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("ptwnwntqfgynyyiy")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Password to access the Dynamics instance.
     */
    @JvmName("keoblmpwxjsaicey")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password to access the Dynamics instance.
     */
    @JvmName("uxfnbcfxiaqahrld")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password to access the Dynamics instance.
     */
    @JvmName("tedkbfwirsdydtig")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The port of on-premises Dynamics server. The property is required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("yosbynbmbtgpafuo")
    public suspend fun port(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("snngtvhnlcnyfgio")
    public suspend
    fun servicePrincipalCredential(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalCredential = mapped
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("emrsseownonkgpsl")
    public fun servicePrincipalCredential(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalCredential = mapped
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("ujlkfpwgmahvqmwd")
    public fun servicePrincipalCredential(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalCredential = mapped
    }

    /**
     * @param value The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string).
     */
    @JvmName("ggkjiwxhjkebsnxd")
    public suspend fun servicePrincipalCredentialType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalCredentialType = mapped
    }

    /**
     * @param value The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("thcpanxmnmmienhl")
    public suspend fun servicePrincipalId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalId = mapped
    }

    /**
     * @param value The URL to the Microsoft Dynamics server. The property is required for on-line and not allowed for on-prem. Type: string (or Expression with resultType string).
     */
    @JvmName("jhuellwrlvnnqnwt")
    public suspend fun serviceUri(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceUri = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Dynamics'.
     */
    @JvmName("klhxmhnswggtuhqv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value User name to access the Dynamics instance. Type: string (or Expression with resultType string).
     */
    @JvmName("redkmpvteyqxoqkp")
    public suspend fun username(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): DynamicsLinkedServiceArgs = DynamicsLinkedServiceArgs(
        annotations = annotations,
        authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
        connectVia = connectVia,
        credential = credential,
        deploymentType = deploymentType ?: throw PulumiNullFieldException("deploymentType"),
        description = description,
        encryptedCredential = encryptedCredential,
        hostName = hostName,
        organizationName = organizationName,
        parameters = parameters,
        password = password,
        port = port,
        servicePrincipalCredential = servicePrincipalCredential,
        servicePrincipalCredentialType = servicePrincipalCredentialType,
        servicePrincipalId = servicePrincipalId,
        serviceUri = serviceUri,
        type = type ?: throw PulumiNullFieldException("type"),
        username = username,
    )
}
