@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ExcelDatasetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Excel dataset.
 * @property annotations List of tags that can be used for describing the Dataset.
 * @property compression The data compression method used for the json dataset.
 * @property description Dataset description.
 * @property firstRowAsHeader When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean).
 * @property folder The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property linkedServiceName Linked service reference.
 * @property location The location of the excel storage.
 * @property nullValue The null value string. Type: string (or Expression with resultType string).
 * @property parameters Parameters for dataset.
 * @property range The partial data of one sheet. Type: string (or Expression with resultType string).
 * @property schema Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
 * @property sheetIndex The sheet index of excel file and default value is 0. Type: integer (or Expression with resultType integer)
 * @property sheetName The sheet name of excel file. Type: string (or Expression with resultType string).
 * @property structure Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
 * @property type Type of dataset.
 * Expected value is 'Excel'.
 */
public data class ExcelDatasetArgs(
    public val annotations: Output<List<Any>>? = null,
    public val compression: Output<DatasetCompressionArgs>? = null,
    public val description: Output<String>? = null,
    public val firstRowAsHeader: Output<Any>? = null,
    public val folder: Output<DatasetFolderArgs>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>,
    public val location: Output<Any>,
    public val nullValue: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val range: Output<Any>? = null,
    public val schema: Output<Any>? = null,
    public val sheetIndex: Output<Any>? = null,
    public val sheetName: Output<Any>? = null,
    public val structure: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ExcelDatasetArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ExcelDatasetArgs =
        com.pulumi.azurenative.datafactory.inputs.ExcelDatasetArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .compression(compression?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .firstRowAsHeader(firstRowAsHeader?.applyValue({ args0 -> args0 }))
            .folder(folder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkedServiceName(linkedServiceName.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location.applyValue({ args0 -> args0 }))
            .nullValue(nullValue?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .range(range?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 }))
            .sheetIndex(sheetIndex?.applyValue({ args0 -> args0 }))
            .sheetName(sheetName?.applyValue({ args0 -> args0 }))
            .structure(structure?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExcelDatasetArgs].
 */
@PulumiTagMarker
public class ExcelDatasetArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var compression: Output<DatasetCompressionArgs>? = null

    private var description: Output<String>? = null

    private var firstRowAsHeader: Output<Any>? = null

    private var folder: Output<DatasetFolderArgs>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var location: Output<Any>? = null

    private var nullValue: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var range: Output<Any>? = null

    private var schema: Output<Any>? = null

    private var sheetIndex: Output<Any>? = null

    private var sheetName: Output<Any>? = null

    private var structure: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("eajfoupjlhcqwjef")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("yqqocyqfbfoixfhq")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("kieggemycnyyossu")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The data compression method used for the json dataset.
     */
    @JvmName("apyfgbldrcrevqfx")
    public suspend fun compression(`value`: Output<DatasetCompressionArgs>) {
        this.compression = value
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("hhinnpkemyotcmsr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ynubvteyjqvextfr")
    public suspend fun firstRowAsHeader(`value`: Output<Any>) {
        this.firstRowAsHeader = value
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("ovtkvinmwxgvpklk")
    public suspend fun folder(`value`: Output<DatasetFolderArgs>) {
        this.folder = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("mdccvmtpwhcxnrgh")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value The location of the excel storage.
     */
    @JvmName("xypkpdtnekckcsax")
    public suspend fun location(`value`: Output<Any>) {
        this.location = value
    }

    /**
     * @param value The null value string. Type: string (or Expression with resultType string).
     */
    @JvmName("njpmlppbxlurkcbt")
    public suspend fun nullValue(`value`: Output<Any>) {
        this.nullValue = value
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("cclweipsvdxwyyod")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The partial data of one sheet. Type: string (or Expression with resultType string).
     */
    @JvmName("gapregvbttgvhdpa")
    public suspend fun range(`value`: Output<Any>) {
        this.range = value
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("xocprtjudrpuouxi")
    public suspend fun schema(`value`: Output<Any>) {
        this.schema = value
    }

    /**
     * @param value The sheet index of excel file and default value is 0. Type: integer (or Expression with resultType integer)
     */
    @JvmName("bpjhfkwhuvouvtpb")
    public suspend fun sheetIndex(`value`: Output<Any>) {
        this.sheetIndex = value
    }

    /**
     * @param value The sheet name of excel file. Type: string (or Expression with resultType string).
     */
    @JvmName("eogsrsmnfcssmeoi")
    public suspend fun sheetName(`value`: Output<Any>) {
        this.sheetName = value
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("gcosslnfhyqmvpag")
    public suspend fun structure(`value`: Output<Any>) {
        this.structure = value
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'Excel'.
     */
    @JvmName("mnvavbsquxsjyksf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("ofmdnbbhwbmdsbtq")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("jsqnunfnjucijrqt")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The data compression method used for the json dataset.
     */
    @JvmName("eikuoovidfphkjrt")
    public suspend fun compression(`value`: DatasetCompressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param argument The data compression method used for the json dataset.
     */
    @JvmName("sqevhhwmboexvulu")
    public suspend fun compression(argument: suspend DatasetCompressionArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetCompressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.compression = mapped
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("fukewsvcawrpxoak")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("xpxtyuklfmhbpgqa")
    public suspend fun firstRowAsHeader(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstRowAsHeader = mapped
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("oixjffcfutaqrnkx")
    public suspend fun folder(`value`: DatasetFolderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folder = mapped
    }

    /**
     * @param argument The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("ffsrxejfadsfoajb")
    public suspend fun folder(argument: suspend DatasetFolderArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetFolderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.folder = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("oygqtsjdlbqsrrgv")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("lhrqhomalqgcbtui")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value The location of the excel storage.
     */
    @JvmName("igbenixqihmbrrsh")
    public suspend fun location(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The null value string. Type: string (or Expression with resultType string).
     */
    @JvmName("gogdsflnmvpfiobr")
    public suspend fun nullValue(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nullValue = mapped
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("yjcihwwnsyseneca")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for dataset.
     */
    @JvmName("yhcoxfnytibtrtpt")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for dataset.
     */
    @JvmName("ewrafrnrydnnbtto")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The partial data of one sheet. Type: string (or Expression with resultType string).
     */
    @JvmName("klpvmbhfyvtcockj")
    public suspend fun range(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.range = mapped
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("erakvugpycadgoyp")
    public suspend fun schema(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value The sheet index of excel file and default value is 0. Type: integer (or Expression with resultType integer)
     */
    @JvmName("txkokwvtnkdhaqaw")
    public suspend fun sheetIndex(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sheetIndex = mapped
    }

    /**
     * @param value The sheet name of excel file. Type: string (or Expression with resultType string).
     */
    @JvmName("kafyigwwsowndmfh")
    public suspend fun sheetName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sheetName = mapped
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("vuhkxhaubsioxxym")
    public suspend fun structure(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.structure = mapped
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'Excel'.
     */
    @JvmName("kkkvjuledfxkhddn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ExcelDatasetArgs = ExcelDatasetArgs(
        annotations = annotations,
        compression = compression,
        description = description,
        firstRowAsHeader = firstRowAsHeader,
        folder = folder,
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        location = location ?: throw PulumiNullFieldException("location"),
        nullValue = nullValue,
        parameters = parameters,
        range = range,
        schema = schema,
        sheetIndex = sheetIndex,
        sheetName = sheetName,
        structure = structure,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
