@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ExecuteDataFlowActivityTypePropertiesComputeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Compute properties for data flow activity.
 * @property computeType Compute type of the cluster which will execute data flow job. Possible values include: 'General', 'MemoryOptimized', 'ComputeOptimized'. Type: string (or Expression with resultType string)
 * @property coreCount Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272. Type: integer (or Expression with resultType integer)
 */
public data class ExecuteDataFlowActivityTypePropertiesComputeArgs(
    public val computeType: Output<Any>? = null,
    public val coreCount: Output<Any>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ExecuteDataFlowActivityTypePropertiesComputeArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.ExecuteDataFlowActivityTypePropertiesComputeArgs =
        com.pulumi.azurenative.datafactory.inputs.ExecuteDataFlowActivityTypePropertiesComputeArgs.builder()
            .computeType(computeType?.applyValue({ args0 -> args0 }))
            .coreCount(coreCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExecuteDataFlowActivityTypePropertiesComputeArgs].
 */
@PulumiTagMarker
public class ExecuteDataFlowActivityTypePropertiesComputeArgsBuilder internal constructor() {
    private var computeType: Output<Any>? = null

    private var coreCount: Output<Any>? = null

    /**
     * @param value Compute type of the cluster which will execute data flow job. Possible values include: 'General', 'MemoryOptimized', 'ComputeOptimized'. Type: string (or Expression with resultType string)
     */
    @JvmName("usyvyncbdevrnoki")
    public suspend fun computeType(`value`: Output<Any>) {
        this.computeType = value
    }

    /**
     * @param value Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272. Type: integer (or Expression with resultType integer)
     */
    @JvmName("kmyjnufonwbebikm")
    public suspend fun coreCount(`value`: Output<Any>) {
        this.coreCount = value
    }

    /**
     * @param value Compute type of the cluster which will execute data flow job. Possible values include: 'General', 'MemoryOptimized', 'ComputeOptimized'. Type: string (or Expression with resultType string)
     */
    @JvmName("jajxxfmtlikyhcke")
    public suspend fun computeType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeType = mapped
    }

    /**
     * @param value Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272. Type: integer (or Expression with resultType integer)
     */
    @JvmName("owftvkottfepcxly")
    public suspend fun coreCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreCount = mapped
    }

    internal fun build(): ExecuteDataFlowActivityTypePropertiesComputeArgs =
        ExecuteDataFlowActivityTypePropertiesComputeArgs(
            computeType = computeType,
            coreCount = coreCount,
        )
}
