@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ExpressionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Data Factory expression definition.
 * @property type Expression type.
 * @property value Expression value.
 */
public data class ExpressionArgs(
    public val type: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ExpressionArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ExpressionArgs =
        com.pulumi.azurenative.datafactory.inputs.ExpressionArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressionArgs].
 */
@PulumiTagMarker
public class ExpressionArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Expression type.
     */
    @JvmName("vpugwpsrcvfqncug")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Expression value.
     */
    @JvmName("lsrmjgcdgvkjwxkd")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Expression type.
     */
    @JvmName("khbkcabuprusbjwx")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Expression value.
     */
    @JvmName("tcuabveqiljcdfvl")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ExpressionArgs = ExpressionArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
