@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.FlowletArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Data flow flowlet
 * @property annotations List of tags that can be used for describing the data flow.
 * @property description The description of the data flow.
 * @property folder The folder that this data flow is in. If not specified, Data flow will appear at the root level.
 * @property script Flowlet script.
 * @property scriptLines Flowlet script lines.
 * @property sinks List of sinks in Flowlet.
 * @property sources List of sources in Flowlet.
 * @property transformations List of transformations in Flowlet.
 * @property type Type of data flow.
 * Expected value is 'Flowlet'.
 */
public data class FlowletArgs(
    public val annotations: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val folder: Output<DataFlowFolderArgs>? = null,
    public val script: Output<String>? = null,
    public val scriptLines: Output<List<String>>? = null,
    public val sinks: Output<List<DataFlowSinkArgs>>? = null,
    public val sources: Output<List<DataFlowSourceArgs>>? = null,
    public val transformations: Output<List<TransformationArgs>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.FlowletArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.FlowletArgs =
        com.pulumi.azurenative.datafactory.inputs.FlowletArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .folder(folder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .script(script?.applyValue({ args0 -> args0 }))
            .scriptLines(scriptLines?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sinks(sinks?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .transformations(
                transformations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowletArgs].
 */
@PulumiTagMarker
public class FlowletArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var folder: Output<DataFlowFolderArgs>? = null

    private var script: Output<String>? = null

    private var scriptLines: Output<List<String>>? = null

    private var sinks: Output<List<DataFlowSinkArgs>>? = null

    private var sources: Output<List<DataFlowSourceArgs>>? = null

    private var transformations: Output<List<TransformationArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the data flow.
     */
    @JvmName("kbbvnelqffnunttx")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("jbmcswrpwhlmylyj")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the data flow.
     */
    @JvmName("itcmwubxlomhdoam")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The description of the data flow.
     */
    @JvmName("kfjrjpricihcgefn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The folder that this data flow is in. If not specified, Data flow will appear at the root level.
     */
    @JvmName("kefuxmmmxkbcwvaf")
    public suspend fun folder(`value`: Output<DataFlowFolderArgs>) {
        this.folder = value
    }

    /**
     * @param value Flowlet script.
     */
    @JvmName("owswnhenjqoaqgjb")
    public suspend fun script(`value`: Output<String>) {
        this.script = value
    }

    /**
     * @param value Flowlet script lines.
     */
    @JvmName("ysguqsnsxooaptit")
    public suspend fun scriptLines(`value`: Output<List<String>>) {
        this.scriptLines = value
    }

    @JvmName("aqxioqdksokficaf")
    public suspend fun scriptLines(vararg values: Output<String>) {
        this.scriptLines = Output.all(values.asList())
    }

    /**
     * @param values Flowlet script lines.
     */
    @JvmName("harjwfpsnyuvjqrf")
    public suspend fun scriptLines(values: List<Output<String>>) {
        this.scriptLines = Output.all(values)
    }

    /**
     * @param value List of sinks in Flowlet.
     */
    @JvmName("asrwfwagmegmsxsb")
    public suspend fun sinks(`value`: Output<List<DataFlowSinkArgs>>) {
        this.sinks = value
    }

    @JvmName("asdoxbdmkbuwobgn")
    public suspend fun sinks(vararg values: Output<DataFlowSinkArgs>) {
        this.sinks = Output.all(values.asList())
    }

    /**
     * @param values List of sinks in Flowlet.
     */
    @JvmName("fjvckyxdlhrmrrct")
    public suspend fun sinks(values: List<Output<DataFlowSinkArgs>>) {
        this.sinks = Output.all(values)
    }

    /**
     * @param value List of sources in Flowlet.
     */
    @JvmName("tqgpkejwhfknlcxv")
    public suspend fun sources(`value`: Output<List<DataFlowSourceArgs>>) {
        this.sources = value
    }

    @JvmName("ohifpdyovekapgef")
    public suspend fun sources(vararg values: Output<DataFlowSourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values List of sources in Flowlet.
     */
    @JvmName("xpxecmxekfwdyccr")
    public suspend fun sources(values: List<Output<DataFlowSourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value List of transformations in Flowlet.
     */
    @JvmName("xygmshwjhyxmapsc")
    public suspend fun transformations(`value`: Output<List<TransformationArgs>>) {
        this.transformations = value
    }

    @JvmName("wrlmuagblhakffft")
    public suspend fun transformations(vararg values: Output<TransformationArgs>) {
        this.transformations = Output.all(values.asList())
    }

    /**
     * @param values List of transformations in Flowlet.
     */
    @JvmName("jywulqdvraghtbeb")
    public suspend fun transformations(values: List<Output<TransformationArgs>>) {
        this.transformations = Output.all(values)
    }

    /**
     * @param value Type of data flow.
     * Expected value is 'Flowlet'.
     */
    @JvmName("vkrhaxosgpyvmkce")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the data flow.
     */
    @JvmName("otatqarrwrvpkwsu")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the data flow.
     */
    @JvmName("dtvfyhnrojtilmyo")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The description of the data flow.
     */
    @JvmName("tlsqxcnebmboadee")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The folder that this data flow is in. If not specified, Data flow will appear at the root level.
     */
    @JvmName("xregfellkwkulaov")
    public suspend fun folder(`value`: DataFlowFolderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folder = mapped
    }

    /**
     * @param argument The folder that this data flow is in. If not specified, Data flow will appear at the root level.
     */
    @JvmName("ucallnjsylkxolmu")
    public suspend fun folder(argument: suspend DataFlowFolderArgsBuilder.() -> Unit) {
        val toBeMapped = DataFlowFolderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.folder = mapped
    }

    /**
     * @param value Flowlet script.
     */
    @JvmName("wnhubkjqwigswolt")
    public suspend fun script(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.script = mapped
    }

    /**
     * @param value Flowlet script lines.
     */
    @JvmName("heanvdoamxonqnve")
    public suspend fun scriptLines(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptLines = mapped
    }

    /**
     * @param values Flowlet script lines.
     */
    @JvmName("pxnyiatwmwxubkfh")
    public suspend fun scriptLines(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scriptLines = mapped
    }

    /**
     * @param value List of sinks in Flowlet.
     */
    @JvmName("acueqvvpbsttvmtv")
    public suspend fun sinks(`value`: List<DataFlowSinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    /**
     * @param argument List of sinks in Flowlet.
     */
    @JvmName("wncjleyhurdfbjfi")
    public suspend fun sinks(argument: List<suspend DataFlowSinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataFlowSinkArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param argument List of sinks in Flowlet.
     */
    @JvmName("diebrrjrqrfptmfg")
    public suspend fun sinks(vararg argument: suspend DataFlowSinkArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataFlowSinkArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param argument List of sinks in Flowlet.
     */
    @JvmName("vxrlujwoiotyareh")
    public suspend fun sinks(argument: suspend DataFlowSinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataFlowSinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param values List of sinks in Flowlet.
     */
    @JvmName("ysdcmivtnvremptv")
    public suspend fun sinks(vararg values: DataFlowSinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    /**
     * @param value List of sources in Flowlet.
     */
    @JvmName("ograkuetjbgrxknv")
    public suspend fun sources(`value`: List<DataFlowSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument List of sources in Flowlet.
     */
    @JvmName("fefiapgfygesrtys")
    public suspend fun sources(argument: List<suspend DataFlowSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataFlowSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument List of sources in Flowlet.
     */
    @JvmName("mjoyvdcliqqyavqq")
    public suspend fun sources(vararg argument: suspend DataFlowSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataFlowSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument List of sources in Flowlet.
     */
    @JvmName("eekdmphutjgoevql")
    public suspend fun sources(argument: suspend DataFlowSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataFlowSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values List of sources in Flowlet.
     */
    @JvmName("chrqockpavawxivf")
    public suspend fun sources(vararg values: DataFlowSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value List of transformations in Flowlet.
     */
    @JvmName("xglwpcykyicxsmip")
    public suspend fun transformations(`value`: List<TransformationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transformations = mapped
    }

    /**
     * @param argument List of transformations in Flowlet.
     */
    @JvmName("phwvvpakawnkhjiw")
    public suspend fun transformations(argument: List<suspend TransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.transformations = mapped
    }

    /**
     * @param argument List of transformations in Flowlet.
     */
    @JvmName("vtqiqysqcewtpfbj")
    public suspend fun transformations(
        vararg
        argument: suspend TransformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.transformations = mapped
    }

    /**
     * @param argument List of transformations in Flowlet.
     */
    @JvmName("fvhdskipbfekrxkd")
    public suspend fun transformations(argument: suspend TransformationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TransformationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.transformations = mapped
    }

    /**
     * @param values List of transformations in Flowlet.
     */
    @JvmName("jjhkrvdqvkhlylke")
    public suspend fun transformations(vararg values: TransformationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transformations = mapped
    }

    /**
     * @param value Type of data flow.
     * Expected value is 'Flowlet'.
     */
    @JvmName("xdwrvkeshvaebnky")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FlowletArgs = FlowletArgs(
        annotations = annotations,
        description = description,
        folder = folder,
        script = script,
        scriptLines = scriptLines,
        sinks = sinks,
        sources = sources,
        transformations = transformations,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
