@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetCredentialOperationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property credentialName Credential name
 * @property factoryName The factory name.
 * @property resourceGroupName The resource group name.
 */
public data class GetCredentialOperationPlainArgs(
    public val credentialName: String,
    public val factoryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetCredentialOperationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GetCredentialOperationPlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetCredentialOperationPlainArgs.builder()
            .credentialName(credentialName.let({ args0 -> args0 }))
            .factoryName(factoryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCredentialOperationPlainArgs].
 */
@PulumiTagMarker
public class GetCredentialOperationPlainArgsBuilder internal constructor() {
    private var credentialName: String? = null

    private var factoryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Credential name
     */
    @JvmName("rxseanickwratlyh")
    public suspend fun credentialName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.credentialName = mapped
    }

    /**
     * @param value The factory name.
     */
    @JvmName("bjjpvugvemamayck")
    public suspend fun factoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.factoryName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("sainjawwecmelyxh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCredentialOperationPlainArgs = GetCredentialOperationPlainArgs(
        credentialName = credentialName ?: throw PulumiNullFieldException("credentialName"),
        factoryName = factoryName ?: throw PulumiNullFieldException("factoryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
