@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetDataFlowPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataFlowName The data flow name.
 * @property factoryName The factory name.
 * @property resourceGroupName The resource group name.
 */
public data class GetDataFlowPlainArgs(
    public val dataFlowName: String,
    public val factoryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetDataFlowPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GetDataFlowPlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetDataFlowPlainArgs.builder()
            .dataFlowName(dataFlowName.let({ args0 -> args0 }))
            .factoryName(factoryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataFlowPlainArgs].
 */
@PulumiTagMarker
public class GetDataFlowPlainArgsBuilder internal constructor() {
    private var dataFlowName: String? = null

    private var factoryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The data flow name.
     */
    @JvmName("jagfwdrmsharenaj")
    public suspend fun dataFlowName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataFlowName = mapped
    }

    /**
     * @param value The factory name.
     */
    @JvmName("njucqqcmnhrhiwao")
    public suspend fun factoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.factoryName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("mubvbkprijvsjseo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDataFlowPlainArgs = GetDataFlowPlainArgs(
        dataFlowName = dataFlowName ?: throw PulumiNullFieldException("dataFlowName"),
        factoryName = factoryName ?: throw PulumiNullFieldException("factoryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
