@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetExposureControlFeatureValueByFactoryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property factoryName The factory name.
 * @property featureName The feature name.
 * @property featureType The feature type.
 * @property resourceGroupName The resource group name.
 */
public data class GetExposureControlFeatureValueByFactoryPlainArgs(
    public val factoryName: String,
    public val featureName: String? = null,
    public val featureType: String? = null,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetExposureControlFeatureValueByFactoryPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.GetExposureControlFeatureValueByFactoryPlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetExposureControlFeatureValueByFactoryPlainArgs.builder()
            .factoryName(factoryName.let({ args0 -> args0 }))
            .featureName(featureName?.let({ args0 -> args0 }))
            .featureType(featureType?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExposureControlFeatureValueByFactoryPlainArgs].
 */
@PulumiTagMarker
public class GetExposureControlFeatureValueByFactoryPlainArgsBuilder internal constructor() {
    private var factoryName: String? = null

    private var featureName: String? = null

    private var featureType: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The factory name.
     */
    @JvmName("htrolqgspxckjpoo")
    public suspend fun factoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.factoryName = mapped
    }

    /**
     * @param value The feature name.
     */
    @JvmName("iqrljdhyydrxdouo")
    public suspend fun featureName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.featureName = mapped
    }

    /**
     * @param value The feature type.
     */
    @JvmName("goxavabebctyanwa")
    public suspend fun featureType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.featureType = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("uliyiapjlcfqfdhy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExposureControlFeatureValueByFactoryPlainArgs =
        GetExposureControlFeatureValueByFactoryPlainArgs(
            factoryName = factoryName ?: throw PulumiNullFieldException("factoryName"),
            featureName = featureName,
            featureType = featureType,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
